// Author: Christian Lim
// Date: July 23, 2025

#include <iostream>
using namespace std;

typedef long long ll;

// Use __int128 for safe large number arithmetic
bool canReach(ll steps, ll r, ll s, ll t) {
  __int128 total = (__int128)(steps / 2) * (r + s);
  if (steps % 2 == 1) total += r;
  return total >= t;
}

int main() {
  int c;
  cin >> c;
  while (c--) {
    ll r, s, t;
    cin >> r >> s >> t;
    ll low = 1, high = 1e18, ans = 1e18;
    while (low <= high) {
      ll mid = low + (high - low) / 2;
      if (canReach(mid, r, s, t)) ans = mid, high = mid - 1;
      else low = mid + 1;
    }
    cout<<ans<<"\n";
  }
  return 0;
}

