#include <iostream>
#include <fstream>
#include <random>
#include <chrono>
#include <vector>
#include <algorithm>

using namespace std;

// Configure test size here
const int NUM_CASES = 10;
const int MAX_N = 1000000;
const int MIN_N = 1;
const int MIN_VAL = -1000000000;
const int MAX_VAL = 1000000000;

int main() {
  ofstream out("input.txt");
  if (!out) {
    cerr << "Error opening output file!\n";
    return 1;
  }

  // Use a seed based on current time
  mt19937_64 rng(chrono::steady_clock::now().time_since_epoch().count());
  uniform_int_distribution<int> case_dist(MIN_N, MAX_N);
  uniform_int_distribution<int> val_dist(MIN_VAL, MAX_VAL);

  out << NUM_CASES << '\n';

  for (int t = 0; t < NUM_CASES; ++t) {
    int n = case_dist(rng);
    uniform_int_distribution<int> k_dist(1, n);
    int k = k_dist(rng);

    out << n << ' ' << k << '\n';
    for (int i = 0; i < n; ++i) {
      out << val_dist(rng);
      if (i + 1 < n) out << ' ';
    }
    out << '\n';
  }

  cout << "Generated " << NUM_CASES << " test cases in input.txt\n";
  return 0;
}
