// Arup Guha
// 7/23/2025
// Solution to 2025 SI@UCF Competitive Programming Camp Contest #5 Problem: Cola Surfing

import java.util.*;

public class surf {

	// Valid directions of movement without blocks between.
	final public static int[] DR = {1,1,2};
	final public static int[] DC = {-1,1,0};

	final public static int w = 21;
	public static int h;
	public static char[][] g;
	public static int octopusH;
	
	public static void main(String[] args) {
	
		Scanner stdin = new Scanner(System.in);
		int numCases = stdin.nextInt();
		
		// Process cases.
		for (int loop=0; loop<numCases; loop++) {
		
			// Octopus starts above me, so negative as h increases going down for me.
			h = stdin.nextInt();
			octopusH = -stdin.nextInt();
			
			// Read grid.
			g = new char[h+1][];
			for (int i=0; i<h+1; i++)
				g[i] = stdin.next().toCharArray();
			
			// d is distance array for surfer.
			int[][] dist = new int[h+1][w];
			for (int i=0; i<h+1; i++)
				Arrays.fill(dist[i], -1);
			
			// This is where we start.
			dist[0][w/2] = 0;
				
			// I will use w*curH + curC to represent location row curH, column curC.
			LinkedList<Integer> q = new LinkedList<Integer>();
			q.offer(w/2);
			
			boolean reached = false;
			
			// Run BFS.
			while (q.size() > 0) {
			
				int curPos = q.poll();
				int cR = curPos/w;
				int cC = curPos%w;
				
				// We made it!
				if (cR >= h-1) {
					reached = true;
					break;
				}
				
				// Try all moves.
				for (int i=0; i<DR.length; i++) {
					int nR = cR + DR[i];
					int nC = cC + DC[i];
					
					// Can't go out of the grid.
					if (!inbounds(nR, nC)) continue;
					
					// Been here before.
					if (dist[nR][nC] != -1) continue;
					
					// Illegal square.
					if (g[nR][nC] == '#') continue;
					
					// Time we would get there.
					int newt = dist[cR][cC] + 1;
					
					// An octopus would get us. They move 2 units down per time step.
					// One exception to this rule is if you are on the bottom row, which is why
					// the and is there.
					if (nR - octopusH == 2*newt && nR < h-1) continue;
					
					// Last issue is if we're moving down 2, we could get blocked, so check that.
					if (nR - cR == 2 && g[nR-1][cC] == '#') continue;
					
					// Update distance and add to queue.
					dist[nR][nC] = dist[cR][cC] + 1;
					q.offer(w*nR + nC);
				}
			} // end-while
			
			// Output accordingly.
			if (reached)
				System.out.println("tubular");
			else
				System.out.println("wipeout");
		
		}
	}
	
	public static boolean inbounds(int myr, int myc) {
		return myr >= 0 && myr <= h && myc >= 0 && myc < w;
	}
}