// C++ solution to "Cola Surfing" from 2025 CS@UCF Summer camp
#include<iostream>
#include<string>
#include<bitset>
#include<vector>
#include<queue>

using namespace std;

#define ROW second
#define COLUMN first
#define MASK_SIZE (10001 << 5)
/*
We can solve the problem using a breadth-first search. This is because if there is any way to win,
it must be possible to win using a path of minimum length from start to end. We know this because
any longer path could only be worse, since taking more edges only allows the octopi to get closer
*/


int compress(pair<int,int> coordinates) {
    return (coordinates.ROW << 5) | coordinates.COLUMN;
}

pair<int,int> decompress(int mask) {
    return {(mask & 31), (mask >> 5)};
}
int main() {
    cin.tie(0)->sync_with_stdio(0);
    bitset<MASK_SIZE> visited;
    int test_count;
    cin >> test_count;

    while(test_count > 0) {
        int high_score, octopi;
        cin >> high_score >> octopi;
        vector<string> ocean(high_score + 1);

        for(int reader = 0 ; reader <= high_score ; reader++) {
            cin >> ocean[reader];
        }
        high_score--;
        queue<pair<int,int>> starts;
        starts.push({compress({10, 0}), 0});

        bool win_found = 0;

        while(starts.size()) {
            pair<int,int> start = starts.front();
            starts.pop();
            pair<int,int> coordinates = decompress(start.first);
            if(coordinates.ROW >= high_score) {
                win_found = 1;
                break;
            }
            if(visited.test(start.first) || start.second >= octopi) {
                continue;
            }
            visited.set(start.first);
            if(ocean[coordinates.ROW + 1][coordinates.COLUMN] == '.' && ocean[coordinates.ROW + 2][coordinates.COLUMN] == '.') {
                starts.push({compress({coordinates.COLUMN, coordinates.ROW + 2}), start.second});
            }

            if(coordinates.COLUMN < 20 && ocean[coordinates.ROW + 1][coordinates.COLUMN + 1] == '.') {
                starts.push({compress({coordinates.COLUMN + 1, coordinates.ROW + 1}), start.second + 1});
            }
            if(coordinates.COLUMN > 0 && ocean[coordinates.ROW + 1][coordinates.COLUMN - 1] == '.') {
                starts.push({compress({coordinates.COLUMN - 1, coordinates.ROW + 1}), start.second + 1});
            }
        }

        if(win_found) {
            cout << "tubular\n";
        } else {
            cout << "wipeout\n";
        }

        test_count--;
        visited &= 0;
    }
    return 0;
}
