// Author: Christian Lim
// Date: July 24, 2025

#include <bits/stdc++.h>
using namespace std;

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  int T; cin >> T;
  while (T--) {
    string s; int k; cin >> s >> k;
    int n = (int)s.size();

    // Map from substring to frequency
    unordered_map<string, int> freq;

    // Generate all substrings
    for (int i = 0; i < n; i++) {
      for (int len = 1; len <= n - i; len++) {
        string sub = s.substr(i, len);
        freq[sub]++;
      }
    }

    // Count how many distinct substrings appear >= k times
    int ans = 0;
    for (auto& [sub, count] : freq) {
      if (count >= k) ans++;
    }

    cout << ans << "\n";
  }

  return 0;
}

