# Arup Guha
# 7/22/2025
# Solution to 2025 SI@UCF Contest #5 Problem: Radix 67

# Given a string of length 6 of 6s and 7s, converts it to a single
# Radix 64 character.
def convert(s):

    # Just do base conversion (to binary) treating 6 as 0.
    val = 0
    for i in range(len(s)):
        val = 2*val + ord(s[i])-ord('6')

    # Range for uppercase letters
    if val < 26:
        return chr(val+ord('A'))

    # Lower case letters
    elif val < 52:
        return chr(val-26+ord('a'))

    # Digits
    elif val < 62:
        return chr(val-52+ord('0'))

    # + sign has to be cased out.
    elif val == 62:
        return '+'

    # As does the forward slash.
    else:
        return '/'
    
# Process cases.
nC = int(input())
for loop in range(nC):

    s = input().strip()

    # Just split up into chunks of 6 and convert each.
    for i in range(0, len(s), 6):
        print(convert(s[i:i+6]), end="")
    print()
