// Author: Christian Lim
// Date: July 22, 2025

#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

vector<ll> generate_palindromes(ll max_limit) {
  vector<ll> palindromes;
  for (int len = 1; len <= 12; ++len) {
    ll start = pow(10, (len - 1) / 2);
    ll end = pow(10, (len + 1) / 2);
    for (ll i = start; i < end; ++i) {
      string left = to_string(i);
      string right = left;
      reverse(right.begin(), right.end());
      if (len % 2 == 1) right.erase(0, 1);
      string full = left + right;
      ll num = stoll(full);
      if (num > max_limit) break;
      palindromes.push_back(num);
    }
  }
  return palindromes;
}

int main() {
  ios::sync_with_stdio(0); cin.tie(0); cout.tie(0);
  int C; cin>>C;
  vector<pair<ll, ll>> queries(C);
  ll max_r=0;
  for (int i=0; i<C; i++) {
    cin>>queries[i].first>>queries[i].second;
    max_r=max(max_r,queries[i].second);
  }
  vector<ll> pals=generate_palindromes(max_r);
  for (auto [l,r] : queries) {
    auto low=lower_bound(pals.begin(), pals.end(), l);
    auto high=upper_bound(pals.begin(), pals.end(), r);
    cout << distance(low, high) << '\n';
  }

  return 0;
}
