#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const int INF = 1e9 + 5;

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  int c;
  cin >> c;
  while (c--) {
    int n, q;
    cin >> n >> q;

    vector<int> wait(n + 1);
    for (int i = 1; i <= n; ++i) {
      cin >> wait[i];
    }

    vector<vector<pair<int, int>>> adj(n + 1);
    for (int i = 0; i < n - 1; ++i) {
      int u, v, x;
      cin >> u >> v >> x;
      adj[u].emplace_back(v, x);
      adj[v].emplace_back(u, x);
    }

    auto bfs = [&](int start) -> vector<int> {
      vector<int> dist(n + 1, INF);
      queue<int> q;
      dist[start] = 0;
      q.push(start);
      while (!q.empty()) {
        int u = q.front(); q.pop();
        for (auto [v, w] : adj[u]) {
          if (dist[v] > dist[u] + w) {
            dist[v] = dist[u] + w;
            q.push(v);
          }
        }
      }
      return dist;
    };

    while (q--) {
      int r, s;
      ll t;
      cin >> r >> s >> t;

      auto dist_from_r = bfs(r);
      auto dist_to_s = bfs(s);

      ll direct = dist_from_r[s];
      if (direct > t) {
        cout << "Oh no!\n";
        continue;
      }

      bool found = false;
      for (int i = 1; i <= n; ++i) {
        ll total = 1LL * dist_from_r[i] + wait[i] + 1LL * dist_to_s[i];
        if (total <= t) {
          found = true;
          break;
        }
      }

      if (found)
        cout << "One last ride!\n";
      else
        cout << "We must hurry!\n";
    }
  }

  return 0;
}
