// Justin Almazan
// 7/23/2025
// Solution to 2025 CP SI @ UCF Contest 5 Problem: One Last Ride

#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int MAXN = 100'005;
const int LOGN = 18;
const ll INF = 1e18;

struct Edge {
    int to, time;
    Edge (int a, int b) { to = a; time = b; }
};

int tt, n, qq;
int d[MAXN] = {0}, bl[MAXN][LOGN];
ll w[MAXN] = {0LL}, walk[MAXN][LOGN], wait[MAXN][LOGN];
vector<vector<Edge>> adj;

void runBL() {

    // Use jump lengths that are powers of 2 (binary)
    for (int j = 1; j < LOGN; j++) {

        // Do this for each node
        for (int i = 1; i <= n; i++) {

            // This is the node that is the ancestor 2^j nodes above i
            int k = bl[i][j-1];

            // Store it in the binary lifting array
            bl[i][j] = bl[k][j-1];

            // Add the walk times of the two halves of the path
            walk[i][j] = walk[i][j-1] + walk[k][j-1];

            // Take the minimum wait time of the two halves of the path
            wait[i][j] = min(wait[i][j-1], wait[k][j-1]);
        }
    }
}

void dfs(int cur, int prv) {
    
    // Update depth
    d[cur] = d[prv] + 1;

    // For each adjacent node that has not been visited...
    for (auto edge : adj[cur]) {
        if (edge.to != prv) {

            // Update binary lifting tables for jump length 1...
            int nxt = edge.to, time = edge.time;
            bl[nxt][0] = cur;
            walk[nxt][0] = time;
            wait[nxt][0] = min(w[nxt], w[cur]);

            // Then visit that node
            dfs(nxt, cur);
        }
    }
}

int query(int a, int b, ll queryTime) {

    // Keep track of total walk time and min wait time
    ll totalWalk = 0, minWait = min(w[a], w[b]);

    // Reduce casework by having a be the node with greatest depth
    if (d[a] < d[b]) swap(a, b);

    // Get difference in depths
    int diff = d[a] - d[b];

    // For node a, jump to its ancestors until it is on the same level as b
    for (int i = 0; i < LOGN; i++) {

        // Only make the jump if the bit is on
        if ((1<<i) & diff) {

            // Update info
            totalWalk += walk[a][i];
            minWait = min(minWait, wait[a][i]);
            a = bl[a][i];
        }
    }

    // Binary search for LCA(a, b)
    for (int i = LOGN-1; i >= 0; i--) {

        // If they are not equal, that means we must keep traversing up the tree from both nodes
        if (bl[a][i] != bl[b][i]) {

            // Update info
            totalWalk += walk[a][i] + walk[b][i];
            minWait = min(minWait, min(wait[a][i], wait[b][i]));
            a = bl[a][i];
            b = bl[b][i];
        }
    }

    // Adjust if off by one after binary search
    if (a != b) {
        totalWalk += walk[a][0] + walk[b][0];
        minWait = min(minWait, min(wait[a][0], wait[b][0]));
        a = bl[a][0];
        b = bl[b][0];
    }

    // Cases for solving the query
    if (totalWalk + minWait <= queryTime) return 1;
    else if (totalWalk <= queryTime) return 2;
    else return 3;
}

int main() {

    // Fast I/O
    cin.tie(0)->sync_with_stdio(0);
	cin.exceptions(cin.failbit);

    // Number of test cases
    cin >> tt;
    
    // Process test cases
    while (tt--) {

        // Number of attractions and queries
        cin >> n >> qq;

        // Get wait time for each line
        for (int i = 1; i <= n; i++) cin >> w[i];

        // Create adjacency list to store the edges
        adj = vector<vector<Edge>>(n+1);

        // Get each edge and add to adjacency list
        for (int i = 1, u, v, x; i <= n-1; i++) {
            cin >> u >> v >> x;
            adj[u].push_back(Edge(v, x));
            adj[v].push_back(Edge(u, x));
        }

        // Root the tree at arbitrary node
        dfs(1, 1);

        // Run binary lifting
        runBL();

        // Process queries
        while (qq--) {

            // Get locations and time
            int r, s; ll t;
            cin >> r >> s >> t;

            // Process query
            int res = query(r, s, t);

            // Case out print statements
            if (res == 1) cout << "One last ride!" << endl;
            else if (res == 2) cout << "We must hurry!" << endl;
            else cout << "Oh no!" << endl;
        }
    }

    return 0;
}