# Author: Christian Lim
# Date: July 23, 2025

import sys
sys.setrecursionlimit(1 << 25)

MAXN = 100005
LOGN = 18
INF = 10**18

class Edge:
    def __init__(self, to, time):
        self.to = to
        self.time = time

def main():
    tt = int(input())
    for _ in range(tt):
        n, qq = map(int, input().split())
        
        # Read weights w[1..n] from a single line
        w = [0] + list(map(int, input().split()))
        
        adj = [[] for _ in range(n + 1)]
        for _ in range(n - 1):
            u, v, x = map(int, input().split())
            adj[u].append(Edge(v, x))
            adj[v].append(Edge(u, x))
        
        d = [0] * (n + 1)
        bl = [[0] * LOGN for _ in range(n + 1)]
        walk = [[0] * LOGN for _ in range(n + 1)]
        wt = [[INF] * LOGN for _ in range(n + 1)]

        def dfs(cur, prv):
            d[cur] = d[prv] + 1
            for edge in adj[cur]:
                if edge.to != prv:
                    nxt, time = edge.to, edge.time
                    bl[nxt][0] = cur
                    walk[nxt][0] = time
                    wt[nxt][0] = min(w[nxt], w[cur])
                    dfs(nxt, cur)

        def runBL():
            for j in range(1, LOGN):
                for i in range(1, n + 1):
                    k = bl[i][j - 1]
                    bl[i][j] = bl[k][j - 1]
                    walk[i][j] = walk[i][j - 1] + walk[k][j - 1]
                    wt[i][j] = min(wt[i][j - 1], wt[k][j - 1])

        def query(a, b, queryTime):
            totalWalk = 0
            minWait = min(w[a], w[b])
            if d[a] < d[b]:
                a, b = b, a
            diff = d[a] - d[b]

            for i in range(LOGN):
                if diff & (1 << i):
                    totalWalk += walk[a][i]
                    minWait = min(minWait, wt[a][i])
                    a = bl[a][i]

            for i in reversed(range(LOGN)):
                if bl[a][i] != bl[b][i]:
                    totalWalk += walk[a][i] + walk[b][i]
                    minWait = min(minWait, wt[a][i], wt[b][i])
                    a = bl[a][i]
                    b = bl[b][i]

            if a != b:
                totalWalk += walk[a][0] + walk[b][0]
                minWait = min(minWait, wt[a][0], wt[b][0])

            if totalWalk + minWait <= queryTime:
                return 1
            elif totalWalk <= queryTime:
                return 2
            else:
                return 3

        dfs(1, 1)
        runBL()

        for _ in range(qq):
            r, s, t = input().split()
            r, s, t = int(r), int(s), int(t)
            res = query(r, s, t)
            if res == 1:
                print("One last ride!")
            elif res == 2:
                print("We must hurry!")
            else:
                print("Oh no!")

if __name__ == "__main__":
    main()
