// Justin Almazan
// 7/23/2025
// Solution to 2025 CP SI @ UCF Contest 5 Problem: One Last Ride

#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int MAXN = 100'005;
const int LOGN = 18;
const ll INF = 1e18;

struct Edge {
  int to, time;
  Edge (int a, int b) { to = a; time = b; }
};

int tt, n, qq;
int d[MAXN] = {0}, bl[MAXN][LOGN];
ll w[MAXN] = {0LL}, walk[MAXN][LOGN], wt[MAXN][LOGN];  // Renamed wait -> wt
vector<vector<Edge>> adj;

void runBL() {
  for (int j = 1; j < LOGN; j++) {
    for (int i = 1; i <= n; i++) {
      int k = bl[i][j-1];
      bl[i][j] = bl[k][j-1];
      walk[i][j] = walk[i][j-1] + walk[k][j-1];
      wt[i][j] = min(wt[i][j-1], wt[k][j-1]);
    }
  }
}

void dfs(int cur, int prv) {
  d[cur] = d[prv] + 1;
  for (auto edge : adj[cur]) {
    if (edge.to != prv) {
      int nxt = edge.to, time = edge.time;
      bl[nxt][0] = cur;
      walk[nxt][0] = time;
      wt[nxt][0] = min(w[nxt], w[cur]);
      dfs(nxt, cur);
    }
  }
}

int query(int a, int b, ll queryTime) {
  ll totalWalk = 0, minWait = min(w[a], w[b]);
  if (d[a] < d[b]) swap(a, b);
  int diff = d[a] - d[b];

  for (int i = 0; i < LOGN; i++) {
    if ((1 << i) & diff) {
      totalWalk += walk[a][i];
      minWait = min(minWait, wt[a][i]);
      a = bl[a][i];
    }
  }

  for (int i = LOGN - 1; i >= 0; i--) {
    if (bl[a][i] != bl[b][i]) {
      totalWalk += walk[a][i] + walk[b][i];
      minWait = min(minWait, min(wt[a][i], wt[b][i]));
      a = bl[a][i];
      b = bl[b][i];
    }
  }

  if (a != b) {
    totalWalk += walk[a][0] + walk[b][0];
    minWait = min(minWait, min(wt[a][0], wt[b][0]));
    a = bl[a][0];
    b = bl[b][0];
  }

  if (totalWalk + minWait <= queryTime) return 1;
  else if (totalWalk <= queryTime) return 2;
  else return 3;
}

int main() {
  cin.tie(0)->sync_with_stdio(0);
  cin.exceptions(cin.failbit);

  cin >> tt;
  while (tt--) {
    cin >> n >> qq;

    for (int i = 1; i <= n; i++) cin >> w[i];

    adj = vector<vector<Edge>>(n + 1);
    for (int i = 1, u, v, x; i <= n - 1; i++) {
      cin >> u >> v >> x;
      adj[u].push_back(Edge(v, x));
      adj[v].push_back(Edge(u, x));
    }

    dfs(1, 1);
    runBL();

    while (qq--) {
      int r, s;
      ll t;
      cin >> r >> s >> t;
      int res = query(r, s, t);
      if (res == 1) cout << "One last ride!" << endl;
      else if (res == 2) cout << "We must hurry!" << endl;
      else cout << "Oh no!" << endl;
    }
  }

  return 0;
}
