#include <bits/stdc++.h>
using namespace std;

#define F first
#define S second

using pii = pair<int, int>;

random_device rd;
mt19937 gen(chrono::steady_clock::now().time_since_epoch().count());

const int MAXN = 1'000;
const int MAXQ = 1'000;
const int MAXW = 10'000;
const int MAXX = 1'000'000;
const int MAXT = 1'000'000'000;
const int NUM_CASES = 18;

int genNumber(int l, int r) {
    uniform_int_distribution<> distr(l, r);
    return distr(gen);
}

void genRandomCase() {
    int n = genNumber(MAXN/2, MAXN);
    int qq = genNumber(MAXQ/2, MAXQ);

    cout << n << " " << qq << endl;

    for (int i = 1; i <= n; i++) {
        cout << genNumber(1, MAXW);
        if (i != n) cout << " ";
    }

    cout << endl;

    vector<pair<int, pii>> adj;

    for (int i = 2; i <= n; i++) {
        int u = i;
        int v = genNumber(1, u-1);
        int w = genNumber(1, MAXX);
        if (genNumber(0, 1) == 1) swap(u, v);
        adj.push_back({w, {u, v}});
    }

    shuffle(adj.begin(), adj.end(), gen);

    for (int i = 0; i < int(adj.size()); i++) {
        cout << adj[i].S.F << " " << adj[i].S.S << " " << adj[i].F << endl;
    }

    while (qq--) {
        int r = genNumber(1, n);
        int s = genNumber(1, n);
        while (r == s) s = genNumber(1, n);
        int t = genNumber(5'000'000, 15'000'000);

        cout << r << " " << s << " " << t << endl;
    }
}

void genMaxCases() {
    int n = MAXN;
    int qq = MAXQ;

    cout << n << " " << qq << endl;

    for (int i = 0; i < n; i++) {
        if (i != 0) cout << " ";
        cout << MAXW;
    }

    for (int i = 1; i < n; i++) {
        cout << i << " " << i+1 << " " << MAXX << endl;
    }

    for (int i = 1; i <= 500; i++) {
        for (int j = n - 499; j <= n; j++) {
            cout << i << " " << j << " " << MAXT << endl;
            qq--;
            if (qq <= 0) break;
        }
        if (qq <= 0) break;
    }

    n = MAXN;
    qq = MAXQ;

    cout << n << " " << qq << endl;

    for (int i = 0; i < n; i++) {
        if (i != 0) cout << " ";
        cout << MAXW;
    }

    cout << 1 << " " << 2 << " " << MAXX << endl;

    for (int i = 3; i <= n; i++) {
        cout << i-2 << " " << i << " " << MAXX << endl;
    }

    for (int i = 99'000; i <= n; i+=2) {
        for (int j = 99'001; j <= n; j+=2) {
            cout << i << " " << j << " " << MAXT << endl;
            qq--;
            if (qq <= 0) break;
        }
        if (qq <= 0) break;
    }
}

void genMinCases() {
    cout << 3 << " " << 11 << endl;
    cout << 10 << " " << 10 << " " << 1 << endl;
    cout << 1 << " " << 2 << " " << 10 << endl;
    cout << 3 << " " << 2 << " " << 1 << endl;

    cout << 3 << " " << 1 << " " << 2 << endl;
    cout << 2 << " " << 3 << " " << 10 << endl;
    cout << 1 << " " << 3 << " " << 1 << endl;
    cout << 1 << " " << 3 << " " << 2 << endl;
    cout << 1 << " " << 3 << " " << 3 << endl;
    cout << 1 << " " << 2 << " " << 9 << endl;
    cout << 1 << " " << 2 << " " << 10 << endl;
    cout << 1 << " " << 2 << " " << 11 << endl;
    cout << 1 << " " << 2 << " " << 19 << endl;
    cout << 1 << " " << 2 << " " << 20 << endl;
    cout << 1 << " " << 2 << " " << 21 << endl;
}

int main() {

    // genMaxCases();
    genMinCases();

    for (int i = 0; i < NUM_CASES; i++) {
        cerr << i << endl;
        genRandomCase();
    }
}