// Justin Almazan
// 7/23/2025
// Solution to 2025 CP SI @ UCF Contest 5 Problem: Good Groupings

#include <bits/stdc++.h>
using namespace std;

int main() {

    // Number of test cases
    int tt; 
    cin >> tt;

    // Process test cases
    while (tt--) {

        // Get values for input case
        int n, qq; 
        cin >> n >> qq;

        // Create set to store names of adults for easy lookup
        set<string> adults;

        // Get name of all adults
        while (n--) {

            // Get name of the adult and insert into set
            string s; 
            cin >> s;
            adults.insert(s);
        }

        // Process queries
        while (qq--) {

            // Keeps track of if we met our conditions
            bool enoughPeople = false;
            bool hasAdult = false;

            // Get the number of people in the group and check the group size condition
            int m;
            cin >> m;
            if (m >= 3) 
                enoughPeople = true;

            // For each person...
            while (m--) {

                // Get the name of the person and check if they are an adult
                string s;
                cin >> s;
                if (adults.count(s)) 
                    hasAdult = true;
            }

            // Both must be good to make a valid group
            if (enoughPeople && hasAdult)
                cout << "Good" << endl;
            else
                cout << "Not good" << endl;
        }
    }

    return 0;
}