#include <bits/stdc++.h>
using namespace std;

const int MAXN = 100;
const int MAXM = 100;
const int MAXQ = 100;
const int MAXL = 15;
const int NUM_CASES = 26;

random_device rd;
mt19937 gen(chrono::steady_clock::now().time_since_epoch().count());

int genNumber(int l, int r) {
    uniform_int_distribution<> distr(l, r);
    return distr(gen);
}

string genString(int len) {
    string s = "";
    while (len--) s += "a";
    for (int i = 0; i < int(s.length()); i++) s[i] += genNumber(0, 25);
    return s;
}

void genRandomCase() {
    int n = genNumber(MAXN/2, MAXN);
    int q = genNumber(MAXQ/2, MAXQ);

    cout << n << " " << q << endl;

    set<string> adults;

    while (n--) {
        int len = genNumber(3, MAXL);
        string s = genString(len);

        cout << s << endl;
        adults.insert(s);
    }

    while (q--) {
        int type = genNumber(0, 2);
        
        if (type == 1) {
            int m = genNumber(3, MAXM);
            int numAdults = genNumber(1, min(m/2, int(adults.size())));

            cout << m;

            vector<string> v;
            auto it = adults.begin();

            for (int i = 0; i < numAdults; i++) {
                v.push_back(*it);
                it++;
            }

            for (int i = numAdults; i < m; i++) {
                v.push_back(genString(genNumber(1, 15)));
            }

            shuffle(v.begin(), v.end(), gen);

            for (int i = 0; i < m; i++) {
                cout << " " << v[i];
            }
        }

        else {
            int m = genNumber(3, MAXM);
            if (q % 11 == 0) m = 2;
            else if (q % 13 == 0) m = 1;

            cout << m;

            while (m--) cout << " " << genString(genNumber(1, MAXL));
        }

        cout << endl;
    }
}

void genMaxCase() {
    int n = MAXN, q = MAXQ;

    cout << n << " " << q << endl;

    vector<string> adults;

    for (int i = 0; i < n; i++) {
        string s = genString(MAXL);
        cout << s << endl;
        adults.push_back(s);
    }

    while (q--) {
        int m = min(MAXM, n);
        
        cout << m;

        int type = genNumber(0, 1);
        
        if (type == 1) {
            shuffle(adults.begin(), adults.end(), gen);
            for (int i = 0; i < m; i++) cout << " " << adults[i];
        }

        else {
            for (int i = 0; i < m; i++) cout << " " << genString(MAXL);
        }

        cout << endl;
    }
}

void genMinCase() {
    cout << 1 << " " << 9 << endl;
    cout << "a" << endl;
    cout << "1 a" << endl;
    cout << "1 b" << endl;
    cout << "2 a b" << endl;
    cout << "2 b a" << endl;
    cout << "2 b c" << endl;
    cout << "3 a b c" << endl;
    cout << "3 c a b" << endl;
    cout << "3 b c a" << endl;
    cout << "3 b c d" << endl;
}

int main() {

    genMinCase();
    genMaxCase();
    
    for (int i = 0; i < NUM_CASES; i++) {
        genRandomCase();
    }
}