// Author: Christian Lim
// Date: July 23, 2025

#include<bits/stdc++.h>
using namespace std;

typedef long long ll;

bool is_vowel(char ch) {
  return ch == 'a' || ch == 'e' || ch == 'i' || ch == 'o' || ch == 'u';
}

int gcd(int a, int b) {
  return (!b) ? a : gcd(b, a % b);
}

int main() {
  ios::sync_with_stdio(0); cin.tie(0); cout.tie(0);
  int c; cin>>c;
  while (c--) {
    string N,B; cin>>N>>B;
    int v0=0, c0=0;
    for (char ch : B) {
      if (is_vowel(ch)) ++v0;
      else ++c0;
    }
    if ((!v0) || (!c0)) {
      ll count=0;
      int n=N.size();
      int run=0;
      for (int i=0; i<n; i++) {
        if (((!v0) && !is_vowel(N[i])) || ((!c0) && is_vowel(N[i])))
          run++, count+=run;
        else {
          run=0;
        }
      }
      cout<<count<<"\n";
      continue;
    }
    unordered_map<ll,ll> balance_count;
    balance_count[0]=1;
    ll ret=0, current_v=0, current_c=0;
    for (char ch : N) {
      if (is_vowel(ch)) ++current_v;
      else ++current_c;
      ll balance = current_v*c0-current_c*v0;
      ret+=balance_count[balance];
      balance_count[balance]++;
    }
    cout<<ret<<"\n";
  }
  return 0;
}
