// Arup Guha
// 7/22/2025
// Solution to 2025 SI@UCF Conteest #5 Problem: Splitting Cake

import java.util.*;
import java.io.*;

public class cake {

	public static int n;
	public static long[] x;
	public static long[] y;
	
	public static void main(String[] args) throws Exception {
	
		FastScanner stdin = new FastScanner(System.in);
		
		int nC = stdin.nextInt();
		for (int loop=0; loop<nC; loop++) {
		
			n = stdin.nextInt();
			x = new long[n];
			y = new long[n];
			for (int i=0; i<n; i++) {
				x[i] = stdin.nextLong();
				y[i] = stdin.nextLong();
			}
			
			// Get twice the whole area.
			long dArea = 0;
			for (int i=0; i<n; i++)
				dArea = dArea + (x[i]*y[(i+1)%n] - x[(i+1)%n]*y[i]); 
			
			// We need area to be positive!
			dArea = Math.abs(dArea);
			
			long best = 0;
			
			long pieceDArea = 0;
			
			// Redo area calculation.
			for (int i=0; i<n; i++) {
			
				// Current running tally of area.
				pieceDArea = pieceDArea + (x[i]*y[(i+1)%n] - x[(i+1)%n]*y[i]); 
				
				// These are degenerate cases.
				if (i == 0 || i == n-1) continue;
				
				// What we add to pieceArea to make the cut.
				long update = x[i+1]*y[0]-x[0]*y[i+1];
				
				// Calculate the positive area of this piece if we cut from vertex 0 to i+1.
				long curDPiece = Math.abs(pieceDArea+update);
				
				// Get the smaller of the two pieces.
				curDPiece = Math.min(curDPiece, dArea - curDPiece);

				// Best will store the largest smallest piece.
				best = Math.max(best, curDPiece);
			}
			
			// Get desired fraction.
			long num = best;
			long den = dArea - best;
			
			// Divide out gcd and print.
			long div = gcd(num, den);
			System.out.println((num/div)+" "+(den/div));
		}
	}
	
	// Returns gcd of a and b.
	public static long gcd(long a, long b) {
		return b == 0 ? a : gcd(b, a%b);
	}
}

class FastScanner {
	BufferedReader br;
	StringTokenizer st;
	public FastScanner(InputStream i){
		br = new BufferedReader(new InputStreamReader(i));
		st = new StringTokenizer("");
	}
	public String next() throws IOException{
		if(st.hasMoreTokens())
			return st.nextToken();
		else
			st = new StringTokenizer(br.readLine());
		return next();
	}
	public int nextInt() throws IOException{
		return Integer.parseInt(next());
	}
	public long nextLong() throws IOException{
		return Long.parseLong(next());
	}
	public double nextDouble() throws IOException{
		return Double.parseDouble(next());
	}
}