// Author: Christian Lim
// Date: July 23, 2025

#include <bits/stdc++.h>
using namespace std;

const int MAX_COORD = 1'000'000;
const int MIN_N = 50000;
const int MAX_N = 100000;
const int CASES = 10;

using Point = pair<int, int>;

long long cross(const Point& O, const Point& A, const Point& B) {
  return 1LL * (A.first - O.first) * (B.second - O.second)
    - 1LL * (A.second - O.second) * (B.first - O.first);
}

vector<Point> convex_hull(vector<Point> P) {
  int n = (int)P.size(), k = 0;
  if (n <= 1) return P;

  sort(P.begin(), P.end());

  vector<Point> H(2 * n);

  // Build lower hull
  for (int i = 0; i < n; ++i) {
    while (k >= 2 && cross(H[k - 2], H[k - 1], P[i]) <= 0) k--;
    H[k++] = P[i];
  }

  // Build upper hull
  for (int i = n - 2, t = k + 1; i >= 0; --i) {
    while (k >= t && cross(H[k - 2], H[k - 1], P[i]) <= 0) k--;
    H[k++] = P[i];
  }

  H.resize(k - 1);
  return H;
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  mt19937 rng(chrono::steady_clock::now().time_since_epoch().count());
  uniform_int_distribution<int> dist_n(MIN_N, MAX_N);
  uniform_real_distribution<double> scale_dist(0.7, 1.0);
  uniform_real_distribution<double> angle_dist(0, 2 * M_PI);

  ofstream fout("cases.txt");
  if (!fout) {
    cerr << "Failed to open cases.txt for writing\n";
    return 1;
  }

  fout << CASES << "\n";

  for (int t = 1; t <= CASES; ++t) {
    int n = dist_n(rng);
    double radius = 900000.0;

    double radius_x = radius * scale_dist(rng);
    double radius_y = radius * scale_dist(rng);
    double angle_offset = angle_dist(rng);

    vector<Point> points;
    points.reserve(n);
    for (int i = 0; i < n; ++i) {
      double angle = angle_offset + 2.0 * M_PI * i / n;
      int x = (int)round(radius_x * cos(angle));
      int y = (int)round(radius_y * sin(angle));
      points.emplace_back(x, y);
    }

    vector<Point> hull = convex_hull(points);
    fout << (int)hull.size() << "\n";
    for (auto& p : hull) {
      fout << p.first << " " << p.second << "\n";
    }
  }

  cerr << "All cases written to cases.txt\n";
  return 0;
}
