// Author: Christian Lim
// Date: July 23, 2025

#include <bits/stdc++.h>
using namespace std;

using Point = pair<long long, long long>;

long long cross(const Point &a, const Point &b, const Point &c) {
  // cross product (b - a) x (c - b)
  long long x1 = b.first - a.first;
  long long y1 = b.second - a.second;
  long long x2 = c.first - b.first;
  long long y2 = c.second - b.second;
  return x1 * y2 - x2 * y1;
}

bool is_convex(const vector<Point>& poly) {
  int n = poly.size();
  int sign = 0;

  for (int i = 0; i < n; ++i) {
    Point a = poly[i];
    Point b = poly[(i + 1) % n];
    Point c = poly[(i + 2) % n];

    long long cp = cross(a, b, c);
    if (cp == 0) return false; // collinear points are not allowed

    if (sign == 0)
      sign = (cp > 0 ? 1 : -1);
    else if ((cp > 0 && sign < 0) || (cp < 0 && sign > 0))
      return false; // non-convex
  }

  return true;
}

int main() {
  ifstream fin("cases.txt");
  if (!fin) {
    cerr << "Failed to open cases.txt\n";
    return 1;
  }

  int T;
  fin >> T;

  for (int t = 1; t <= T; ++t) {
    int n;
    fin >> n;

    vector<Point> poly(n);
    for (int i = 0; i < n; ++i) {
      fin >> poly[i].first >> poly[i].second;
    }

    if (is_convex(poly)) {
      cout << "Case #" << t << ": Convex ✅\n";
    } else {
      cout << "Case #" << t << ": Not Convex ❌\n";
    }
  }

  return 0;
}

