;;; $Id: remove-attributes.tst,v 1.1 2005/02/15 04:42:46 leavens Exp $

(newline)
(displayln "Test case of $Date: 2005/02/15 04:42:46 $")
(newline)

(define sample1
  '(*TOP*
    (WEIGHINGS
     (WEIGHT (@ (unit "pound"))
	     (NET (@ (certified)) "67")
	     (GROSS "95"))
     (WEIGHT (@ (unit "kgs"))
	     (NET (@ (certified)) "54.7")
	     (GROSS "85.2"))
    )))

(define poems
  '(*TOP*
    (poems
     (poem (@ (title "The Lovesong of J. Alfred Prufrock")
	      (poet "T. S. Eliot"))
	   (stanza
	    (line "Let us go then, you and I,")
	    (line "When the evening is spread out against the sky")
	    (line "Like a patient etherized upon a table:"))
	   (stanza (@ (critics-say "too sing-songy"))
	    (line "In the room the women come and go")
	    (line "Talking of Michaelangelo.")
	    (line "...")))
    
     (poem (@ (title "Sonnet XLIII")
	      (from "Sonnets from the Portuguese")
	      (poet "Elizabeth Barrett Browning"))
	   (stanza
	    (line (@ (famous))
		  "How do I love thee?  Let me count the ways.")
	    (line "I love thee to the depth and breadth and height")
	    (line "My soul can reach, when feeling out of sight")
	    (line (@ (note "most can't remember this far"))
		  "For the ends of Being and ideal Grace.")
	    (line "...")))

     (poem (@ (title "To The Weavers Gin Ye Go")
	      (from "POEMS AND SONGS OF ROBERT BURNS")
	      (poet "Robert Burns"))
	   (stanza
	    
	    (line "My heart was ance as blithe and free")
	    (line "As simmer days were lang;")
	    (line "But a bonie, westlin weaver lad")
	    (line "Has gart me change my sang."))

	   (chorus (@ (drunken))
	    (line "To the weaver's gin ye go, fair maids,")
	    (line "To the weaver's gin ye go;")
	    (line "I rede you right, gang ne'er at night,")
	    (line "To the weaver's gin ye go."))

	   (stanza
	    (line "My mither sent me to the town,")
	    (line (@ (def-needed "plaiden"))
		  "To warp a plaiden wab;")
	    (line "But the weary, weary warpin o't")
	    (line "Has gart me sigh and sab."))

	   (chorus (@ (one more time))
	    (line "To the weaver's, &c.")))
     )))


(define slides
  '(*TOP*
    (html
     (head (title "Slides"))
     (body
      (p (@ (align "center"))
	 (table (@ (style "font-size: x-large"))
		(tr
		 (td (@ (align "right")) "Talks ")
		 (td (@ (align "center")) " = ")
		 (td " slides + transition"))
		(tr (td)
		    (td (@ (align "center")) " = ")
		    (td " data + control"))
		(tr (td)
		    (td (@ (align "center")) " = ")
		    (td " programs"))))
      (ul
       (li (a (@ (href "slides/slide0001.gif")) "Introduction"))
       (li (a (@ (href "slides/slide0010.gif")) "Summary")))
      ))))

(define simpledoc
  (document
    (list (PI 'x86 "run; die"))
    (list (comment "those x86s..."))
    (named
     'html
     (list
      (child (attributed 'head
			 (list (name-value 'title "Simple doc"))
			 '()))
      (child
       (named 'body
	      (list (child (named 'p (list (text "First paragraph."))))
		    (child (named 'p (list (text "Second paragraph."))))
		    )))))))

(run-regression-tests-equal?
 `(

   ( (remove-attributes
      (document '() '()
		(attributed
		 'html
		 (list (name-value 'selected "true"))
		 (list ))))
     ==> (*TOP* (html)) )

   ( (remove-attributes
      (document '() '()
                (attributed
                 'weighings
		 (list (name-value 'units "KGs"))
                 (list (child (named 'weight (list (text "42"))))))))
     ==> (*TOP* (weighings (weight "42"))) )

   ( (remove-attributes simpledoc)
     ==> (*TOP* (*PI* x86 "run; die")
                (*COMMENT* "those x86s...")
                (html
                 (head)
                 (body (p "First paragraph.")
                       (p "Second paragraph.")))) )

   ( (remove-attributes sample1)
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (NET "67")
	    (GROSS "95"))
	   (WEIGHT
	    (NET "54.7")
	    (GROSS "85.2")))) )
   ( (remove-attributes
      '(*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (unit "pound"))
	    (NET (@ (certified)) "67")
	    (GROSS (@ (selected "true")) "95"))
	   (WEIGHT
	    (@ (unit "kgs"))
	    (NET (@ (certified)) "54.7")
	    (GROSS (@ (selected "true")) "85.2")))))
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (NET "67")
	    (GROSS "95"))
	   (WEIGHT
	    (NET "54.7")
	    (GROSS "85.2")))) )
   ( (remove-attributes poems)
     ==> (*TOP*
	  (poems
	   (poem
		 (stanza
		  (line "Let us go then, you and I,")
		  (line "When the evening is spread out against the sky")
		  (line "Like a patient etherized upon a table:"))
		 (stanza
		  (line "In the room the women come and go")
		  (line "Talking of Michaelangelo.")
		  (line "...")))
	   (poem
		 (stanza
		  (line "How do I love thee?  Let me count the ways.")
		  (line "I love thee to the depth and breadth and height")
		  (line "My soul can reach, when feeling out of sight")
		  (line "For the ends of Being and ideal Grace.")
		  (line "...")))
	   (poem 
		 (stanza
		  (line "My heart was ance as blithe and free")
		  (line "As simmer days were lang;")
		  (line "But a bonie, westlin weaver lad")
		  (line "Has gart me change my sang."))
		 (chorus
		  (line "To the weaver's gin ye go, fair maids,")
		  (line "To the weaver's gin ye go;")
		  (line "I rede you right, gang ne'er at night,")
		  (line "To the weaver's gin ye go."))
		 (stanza
		  (line "My mither sent me to the town,")
		  (line "To warp a plaiden wab;")
		  (line "But the weary, weary warpin o't")
		  (line "Has gart me sigh and sab."))
		 (chorus (line "To the weaver's, &c."))))) )

   ( (remove-attributes slides)
     ==> (*TOP*
	  (html (head (title "Slides"))
		(body (p 
			 (table
			  (tr (td 
				  "Talks ")
			      (td " = ")
			      (td " slides + transition"))
			  (tr (td )
			      (td " = ")
			      (td " data + control"))
			  (tr (td )
			      (td " = ")
			      (td " programs"))))
		      (ul (li (a 
				 "Introduction"))
			  (li (a 
				 "Summary")))))) )
   )
 )

(newline)
(newline)
