;;; $Id

(module digraph-as-proc  (lib "typedscm.ss" "typedscm")

  (provide empty-digraph add-edge adjacent-to?)

  (deftype empty-digraph (-> () digraph))
  (deftype add-edge
    (-> (digraph node node) digraph))
  (deftype adjacent-to? (-> (digraph node node) boolean))
  
  ;; provides node-equal? and node?
  (require (lib "node-mod.scm" "homework" "hwex"))
  
  (defrep (digraph (-> (node node) boolean)))

  (define empty-digraph
    (lambda ()
      (lambda (from to) #f)))

  (define add-edge
    (lambda (old-graph new-from new-to)
      (lambda (from to)
        (or (and (node-equal? new-from from)
                 (node-equal? new-to to))
            (adjacent-to? old-graph from to)))))

  (define adjacent-to?
    (lambda (graph from to)
      (graph from to)))

) ;; end module
