;;; $Id: value-result.tst,v 1.6 2006/04/25 21:15:01 leavens Exp $

(newline)
(displayln "Test case $RCSfile: value-result.tst,v $ of $Date: 2006/04/25 21:15:01 $")
(newline)

;; check for proper use of expressed value domain
(run-test-case '(run "proc (x) x"))

(run-regression-tests-equal?
 `(
    ( (run "let x = 3 in x") ==> 3 )
    ( (run "let z = 3
                p = proc (x) begin set x = +(x,1); x end
            in (p z)") ==> 4)
    ( (run "let z = 3
                p = proc (x) begin set x = +(x,1); x end
            in begin (p z);
                     z
               end") ==> 4)
    ( (run "let swap = proc(x,y)
                       let temp = 0
                       in begin
                            set temp = x;
	                    set x = y;
                            set y = temp
	                  end
                a = 3
                b = 4
            in begin
                 (swap a b);
                 +(*(100,a), b)
               end") ==> 403 )
    ( (run "let assign2 = proc(v1, v2, e1, e2)
                              begin
            		    set v1 = e1;
            		    set v2 = e2
            	          end
            in let swap4 = proc(x,y)
                            (assign2 x y y x)
                   a = 3
                   b = 4
            in begin
                 (swap4 a b);
                 +(*(100,a), b)
               end") ==> 304 )
    ( (run "let three = 3
            in let x = three
               in begin
                   set x = +(x, 1);
                   +(*(100,three), x)
                  end") ==> 304 )

    ( (run "let addInTo = proc(c,a,b)
		  begin set c = b;
                        set c = +(c,a);
                        c
		  end
            in let x = 3
                   y = 4
               in let res = (addInTo x x y)
                  in +(*(10000,res), +(*(100,x), y))") ==> 70304 )
    ( (run "let a0 = 342
                a1 = 541
            in let i = 100
               in let f = proc(x,b0,b1) begin
                                         set x = +(9,i);
                                         set a0 = i;
                                         set b1 = b0
                                       end
                  in begin (f i a0 a1);
                           +(*(1000000000,
                               +(*(100000,i), +(*(1000,a0),a1))),
                            +(*(1000000,i), +(*(1000,a0),a1)))
                     end") ==> 11242342109342342 )
    ( (run "let c = 3
                p = proc (x) set x = 5
           in begin
               (p add1(c));
               c
              end") ==> 3 )
    ( (run "((proc (x) x proc(y) y) 3)") ==> 3 )
    )
 )
