;; $Id: ref.tst,v 1.3 2006/04/25 21:14:01 leavens Exp $

(newline)
(displayln "Test case $RCSfile: ref.tst,v $ of $Date: 2006/04/25 21:14:01 $")
(newline)

;; Make sure refs are expressed values
(run-test-case '(run "let x = 3 in ref x"))

(run-regression-tests-equal?
 `(
   ( (run "let x = 3 in deref(ref x)")
     ==> 3)
   ( (run "let x = 3
           in let rx = ref x
              in +(1, deref(rx))")
     ==> 4)
   ( (run "let x = 3
           in let rx = ref x
              in begin set x = 7;
                       +(1, deref(rx))
                 end")
     ==> 8)
   ( (run "let x = 3
           in let rx = ref x
              in setref(rx, 5)")
     ==> 0)
   ( (run "let x = 3
           in let rx = ref x
              in begin setref(rx, 8);
                       deref(rx)
                 end")
     ==> 8)
   ( (run "let x = 3
               y = 4
               id = proc(z) z
           in let rx = ref x
                  ry = (id ref y)
              in begin set x = 2;
                       setref(rx, +(deref(ry), deref(rx)));
                       setref(ry, *(1000, deref(rx)));
                       +(x, y)
                 end")
     ==> 6006)

   ( (run "let a = 3
               b = 4
               swap = proc(x,y)
                      let temp = deref(x)
                      in begin
                           setref(x, deref(y));
                           setref(y, temp)
                        end
           in begin
                (swap ref a ref b);
                -(a, b)
              end")
     ==> 1 )
   )
 )
