;; $Id: strength-reduce.tst,v 1.4 2006/02/28 03:06:42 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: strength-reduce.tst,v $ of $Date: 2006/02/28 03:06:42 $")
(newline)

(define exp0 '(4 ** 3))
(define exp0-ans exp0)
(define exp1 '((17 + (- 18)) * 2))
(define exp1-ans '((17 + (- 18)) + (17 + (- 18))))
(define exp2 '(- ((3 - (- 4)) ** 2)))
(define exp2-ans '(- ((3 - (- 4)) * (3 - (- 4)))))
(define exp3 `(,exp1 + ,exp2))
(define exp3-ans `(,exp1-ans + ,exp2-ans))
(define exp4 `((,exp2 + ,exp3) 
               *
               ((15 * (- (- 2))) ** 2)))
(define exp4-ans `((,exp2-ans + ,exp3-ans)
		   *
		   ((15 * (- (- 2))) * (15 * (- (- 2))))))
(define exp5 `((,exp3 + ,exp2) 
               *
               ((24 + 2) - 2)))
(define exp5-ans `((,exp3-ans + ,exp2-ans) 
		   *
		   ((24 + 2) - 2)))
(define exp6 `((10 * ,exp3) - ,exp4))
(define exp6-ans `((10 * ,exp3-ans) - ,exp4-ans))

(define exp7 '(2 ** 2))
(define exp7-ans '(2 + 2))

(define exp8 `(,exp6 - (,exp7 ** (0 + , exp7))))
(define exp8-ans `(,exp6-ans - (,exp7-ans ** (0 + , exp7-ans))))


(run-regression-tests-equal?
 `(
   ( (strength-reduce
	 (binary-op-exp (lit-exp 4) (exponent-op) (lit-exp 2)))
	   = (binary-op-exp (lit-exp 4) (times-op) (lit-exp 4)) )
   ( (strength-reduce (parse-arith-expr '(4 ** 2)))
	   = (binary-op-exp (lit-exp 4) (times-op) (lit-exp 4)) )
   ( (strength-reduce (parse-arith-expr '(- (3 * 2))))
	   = (unary-minus-exp
	       (binary-op-exp (lit-exp 3) (plus-op) (lit-exp 3))) )
   ( (strength-reduce (parse-arith-expr 3))
           = (lit-exp 3) )
   ( (strength-reduce (parse-arith-expr '(- ((7 ** (1 + 1)) * (5 - 3)))))
	   = (unary-minus-exp
	       (binary-op-exp
		(binary-op-exp
		 (lit-exp 7)
		 (exponent-op)
		 (binary-op-exp (lit-exp 1) (plus-op) (lit-exp 1)))
		(times-op)
		(binary-op-exp (lit-exp 5) (minus-op) (lit-exp 3)))) )
   ( (strength-reduce (parse-arith-expr ',exp0))
     = (parse-arith-expr ',exp0-ans) )
   ( (strength-reduce (parse-arith-expr ',exp1))
     = (parse-arith-expr ',exp1-ans) )
   ( (strength-reduce (parse-arith-expr ',exp2))
     = (parse-arith-expr ',exp2-ans) )
   ( (strength-reduce (parse-arith-expr ',exp3))
     = (parse-arith-expr ',exp3-ans) )
   ( (strength-reduce (parse-arith-expr ',exp4))
     = (parse-arith-expr ',exp4-ans) )
   ( (strength-reduce (parse-arith-expr ',exp5))
     = (parse-arith-expr ',exp5-ans) )
   ( (strength-reduce (parse-arith-expr ',exp6))
     = (parse-arith-expr ',exp6-ans) )
   ( (strength-reduce (parse-arith-expr ',exp7))
	   = (parse-arith-expr ',exp7-ans) )
   ( (strength-reduce (parse-arith-expr '((2 ** 2) ** (2 ** 2))))
	   = (binary-op-exp
	      (binary-op-exp (lit-exp 2) (plus-op) (lit-exp 2))
	      (exponent-op)
	      (binary-op-exp (lit-exp 2) (plus-op) (lit-exp 2))) )
   ( (strength-reduce (parse-arith-expr ',exp8))
	   = (parse-arith-expr ',exp8-ans) )
   )
 )
