;; $Id: inf-set.tst,v 1.2 2006/02/28 03:06:42 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: inf-set.tst,v $ of $Date: 2006/02/28 03:06:42 $")
(newline)

   (deftype the-empty-inf-set inf-set)
   (define the-empty-inf-set
     (inf-set-comprehend (lambda (x) #f)))
   
   (deftype universal-inf-set T)
   (define universal-inf-set
     (inf-set-comprehend (lambda (x) #t)))

   (deftype greater-than-maker (-> (number) inf-set))
   (define greater-than-maker
     (lambda (n)
       (inf-set-comprehend
	(lambda (x)
	  (and (number? x) 
	       (> (has-type-trusted number x) n))))))

   (deftype greater-than-5 inf-set)
   (define greater-than-5
     (greater-than-maker 5))

   (deftype less-than-maker (-> (number) inf-set))
   (define less-than-maker
     (lambda (n)
       (inf-set-comprehend
	(lambda (x)
	  (and (number? x) 
	       (< (has-type-trusted number x) n))))))

   (deftype less-than-49 inf-set)
   (define less-than-49
     (less-than-maker 49))

   (deftype between6-and-48 inf-set)
   (define between-6-and-48
     (inf-set-intersection greater-than-5 less-than-49))

   (deftype less-than-6-or-greater-than-48 inf-set)
   (define less-than-6-or-greater-than-48
     (inf-set-complement between-6-and-48))

   (deftype less-than-0-or-greater-than-100 inf-set)
   (define less-than-0-or-greater-than-100
     (inf-set-union (less-than-maker 0)
                (greater-than-maker 100)))

   (deftype inf-set-add (-> (T inf-set) inf-set))
   (define inf-set-add
     (lambda (x inf-set)
       (inf-set-union (inf-set-comprehend (lambda (e) (equal? e x)))
                  inf-set)))

   (deftype LT-0-or-GT-100-or-EQ-50 inf-set)
   (define LT-0-or-GT-100-or-EQ-50
     (inf-set-add 50 less-than-0-or-greater-than-100)) 

(run-regression-tests-equal?
 `(
   ( (inf-set-member? 342 the-empty-inf-set) ==> #f )
   ( (inf-set-member? 'x universal-inf-set) ==> #t )
   ( (inf-set-member? 3 (inf-set-comprehend number?)) ==> #t )
   ( (inf-set-member? 'b (inf-set-comprehend number?)) ==> #f )
   ( (inf-set-member? 3 greater-than-5) ==> #f )
   ( (inf-set-member? 7 greater-than-5) ==> #t )
   ( (inf-set-member? 5 greater-than-5) ==> #f )
   ( (inf-set-member? 7 (inf-set-union (greater-than-maker 5)
			      (inf-set-complement (greater-than-maker 342))))
	==> #t )
   ( (inf-set-member? 5 (inf-set-intersection (greater-than-maker 5)
			            (inf-set-complement (greater-than-maker 342))))
	==> #f )
   ( (inf-set-member? 5 less-than-6-or-greater-than-48) ==> #t )
   ( (inf-set-member? 6 less-than-6-or-greater-than-48) ==> #f )
   ( (inf-set-member? 48 less-than-6-or-greater-than-48) ==> #f )
   ( (inf-set-member? 49 less-than-6-or-greater-than-48) ==> #t )
   ( (inf-set-member? 999999999999 less-than-6-or-greater-than-48) ==> #t )
   ( (inf-set-member? 5 between-6-and-48) ==> #f )
   ( (inf-set-member? 6 between-6-and-48) ==> #t )
   ( (inf-set-member? 48 between-6-and-48) ==> #t )
   ( (inf-set-member? 49 between-6-and-48) ==> #f )
   ( (inf-set-member? -1 LT-0-or-GT-100-or-EQ-50) ==> #t )
   ( (inf-set-member? 0 LT-0-or-GT-100-or-EQ-50) ==> #f )
   ( (inf-set-member? 50 LT-0-or-GT-100-or-EQ-50) ==> #t )
   ( (inf-set-member? 100 LT-0-or-GT-100-or-EQ-50) ==> #f )
   ( (inf-set-member? 101 LT-0-or-GT-100-or-EQ-50) ==> #t )
   ))

