;; $Id: eval-arith-expr.tst,v 1.3 2006/02/28 03:06:42 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: eval-arith-expr.tst,v $ of $Date: 2006/02/28 03:06:42 $")
(newline)

(define exp0 '(4 ** 3))
(define exp1 '((17 + (- 18)) * (13 - 14)))
(define exp2 '((3 - (- 4)) * ((4 - 5) + 20)))
(define exp3 `(,exp1 + ,exp2))
(define exp4 `((,exp2 + ,exp3) 
               *
               ((15 + (- 14)) * (9 + 1))))
(define exp5 `((,exp2 + ,exp3) 
               *
               ((24 + (- 24)) * (6 * 9))))
(define exp6 `((10 * ,exp3) - ,exp4))

(run-regression-tests-equal?
 `(
   ( (eval-arith-expr (lit-exp 3)) ==> 3 )
   ( (eval-arith-expr (lit-exp 4)) ==> 4 )
   ( (eval-arith-expr 
       (unary-minus-exp (lit-exp 3))) ==> -3 )
   ( (eval-arith-expr 
       (unary-minus-exp 
       (binary-op-exp (lit-exp 3)
                     (plus-op)
                     (binary-op-exp (lit-exp 4)
                                   (times-op)
                                   (lit-exp 2)))) ) ==> -11 )
   ( (eval-arith-expr 
       (binary-op-exp (lit-exp 3)
                     (plus-op)
                     (binary-op-exp (lit-exp 4)
                                   (times-op)
                                   (lit-exp 2))) ) ==> 11 )
   ( (eval-arith-expr (parse-arith-expr ',exp0)) ==> 64 )
   ( (eval-arith-expr (parse-arith-expr ',exp1)) ==> 1 )
   ( (eval-arith-expr (parse-arith-expr ',exp2)) ==> 133 )
   ( (eval-arith-expr (parse-arith-expr ',exp3)) ==> 134 )
   ( (eval-arith-expr (parse-arith-expr ',exp4)) ==> 2670 )
   ( (eval-arith-expr (parse-arith-expr ',exp5)) ==> 0 )
   ( (eval-arith-expr (parse-arith-expr ',exp6)) ==> -1330 )
   ( (eval-arith-expr
      (binary-op-exp (lit-exp 4) (exponent-op) (lit-exp 2)))
		==> 16 )
   ( (eval-arith-expr
	 (binary-op-exp (lit-exp 4) (exponent-op) (lit-exp 3)))
		==> 64 )
   ( (eval-arith-expr (lit-exp 3)) ==> 3 )
   ( (eval-arith-expr (lit-exp 4)) ==> 4 )
   ( (eval-arith-expr
      (unary-minus-exp (lit-exp 3))) ==> -3 )
   ( (eval-arith-expr
	 (binary-op-exp (lit-exp 3)
		       (plus-op)
		       (binary-op-exp (lit-exp 4) (exponent-op) (lit-exp 2))))
		==> 19 )
   )
 )
