;; $Id: bound-vars.tst,v 1.4 2006/02/28 03:06:42 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: bound-vars.tst,v $ of $Date: 2006/02/28 03:06:42 $")
(newline)

(define lexp1 '(lambda (x) (f x)))
(define lexp2 `(lambda (z) (,lexp1 (g (h y)))))
(define lexp3 `(lambda (f) ,lexp2))
(define lexp4 `(,lexp3 (car (cdr (x (y (quote z)))))))
(define lexp5 `(lambda (y) ,lexp4))
(define lexp6 `(lambda (f) ,lexp4))
(define lexp7 `(,lexp5 ,lexp2))

(run-regression-tests-equal?
 `(
   ( (set-equal? (bound-vars (parse-expression 'x))
		 (set)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression '(quote z)))
		 (set)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression '(x y)))
		 (set)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression '(lambda (x) (lambda (x) y))))
		 (set)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp1))
		 (set 'x)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp2))
		 (set 'x)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp3))
		 (set 'f 'x)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp4))
		 (set 'f 'x)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp5))
		 (set 'y 'f 'x)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp6))
		 (set 'f 'x)) ==> #t )
   ( (set-equal? (bound-vars (parse-expression ',lexp7))
		 (set 'y 'f 'x)) ==> #t )
   ))

