// $Id: BinaryTree.h,v 1.1 2005/02/28 20:40:33 leavens Exp leavens $
#include <iostream.h>
#include <stdlib.h>

class BinaryTree {
 public:
  virtual bool isLeaf() = 0;
    //@ public invariant: !isLeaf() ==> this instanceof Interior;

  virtual int leafSum();
};

class Leaf : public BinaryTree {
 private:
  int num;

 public:
  bool isLeaf();
  virtual int number();
  Leaf(int n);
};

class Interior : public BinaryTree {
 private:
  char* sym;
  BinaryTree* left; BinaryTree *right;

  //@ private invariant: sym != NULL && left != NULL && right != NULL;

 public:
  bool isLeaf();
  virtual BinaryTree* left_tree();
  virtual BinaryTree* right_tree();
  virtual char* symbol();

  //@ requires: l != NULL && s != NULL && r != NULL;
  Interior(BinaryTree* l, char* s, BinaryTree* r);
};
