// $Id: BinaryTree.cpp,v 1.1 2005/02/28 20:40:33 leavens Exp leavens $

#include <iostream>

#include "BinaryTree.h"

int BinaryTree::leafSum() {
  if (this->isLeaf()) {
    return dynamic_cast<Leaf*>(this)->number();
  } else {
    Interior* meAsInterior = dynamic_cast<Interior*>(this);
    return meAsInterior->left_tree()->leafSum()
      + meAsInterior->right_tree()->leafSum();
  }
}

bool Leaf::isLeaf() { return true; }
int Leaf::number() { return num; }
Leaf::Leaf(int n) { num = n; }

bool Interior::isLeaf() { return false; }
BinaryTree* Interior::left_tree() { return left; }
BinaryTree* Interior::right_tree() { return right; }
char* Interior::symbol() { return sym; }

Interior::Interior(BinaryTree* l, char* s, BinaryTree* r) {
  left = l;
  sym = s;
  right = r;
}

int main() {

  using namespace std;

  BinaryTree *tree_a
    = new Interior(new Leaf(2), "a", new Leaf(3));
  cout << tree_a->leafSum() << endl;
  
  return(0);
}
