;; $Id: lexical-address.tst,v 1.7 2006/02/14 05:50:51 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: lexical-address.tst,v $ of $Date: 2006/02/14 05:50:51 $")
(newline)

(define lexp0 '(lambda (x z) (if p (f x g) (f y h))))
(define lexp1 '(lambda (x) (if p (f x g) (f y h))))
(define lexp2 `(lambda (f g h y p) (,lexp1 (if g h y))))
(define lexp3 `(lambda (f) ,lexp2))
(define lexp4 `(,lexp3 (if (null? (car (cdr x))) y z)))
(define lexp5 `(lambda (x y z) ,lexp4))
(define lexp6 `(lambda (null? car cdr) ,lexp5))
(define lexp7 `(lambda (car cdr) ,lexp5))
(define lexp8 `(lambda (car cdr) (lambda () ,lexp5)))
(define lexp9 `(lambda (f g h y p) (,lexp1 (if g (quote h) (quote y)))))

(run-regression-tests-equal?
 `(
   (	(lexical-address (var-exp 'car))
	= (la:var-exp (lexical-addr 'car 0 0)) )
   (	(lexical-address (quote-exp 'car))
	= (la:quote-exp 'car) )
   (	(lexical-address
	 (lambda-exp '(f) (app-exp (var-exp 'f)
				   (list (quote-exp 'car)))))
	= (la:lambda-exp '(f) (la:app-exp (la:var-exp (lexical-addr 'f 0 0))
					  (list (la:quote-exp 'car)))) )
   (	(lexical-address (var-exp 't))
	= (la:var-exp (lexical-addr 't 0 0)) )
   (	(lexical-address
	 (lambda-exp
	  '(car ls)
	  (app-exp (var-exp 'car)
		   (list (var-exp 'ls)))))
	= (la:lambda-exp
	   '(car ls)
	   (la:app-exp (la:var-exp (lexical-addr 'car 0 0))
		       (list (la:var-exp (lexical-addr 'ls 0 1))))) )
   (	(lexical-address
	 (lambda-exp
	  '(ls car)
	  (app-exp (var-exp 'car)
		   (list (var-exp 'ls)))))
	= (la:lambda-exp
	   '(ls car)
	   (la:app-exp (la:var-exp (lexical-addr 'car 0 1))
		       (list (la:var-exp (lexical-addr 'ls 0 0))))) )
   (	(lexical-address
	 (lambda-exp
	  '(ls car)
	  (app-exp (var-exp 'ls) (list))))
	= (la:lambda-exp
	   '(ls car)
	   (la:app-exp (la:var-exp (lexical-addr 'ls 0 0)) (list))) )
  ( (lexical-address (parse-expression ',lexp6))
     =
     (parse-lexical-addr-exp
      '(lambda (null? car cdr)
	 (lambda (x y z)
	   ((lambda (f)
	      (lambda (f g h y p)
		((lambda (x)
		   (if (p : 1 4)
		       ((f : 1 0) (x : 0 0) (g : 1 1))
		       ((f : 1 0) (y : 1 3) (h : 1 2))))
		 (if (g : 0 1) (h : 0 2) (y : 0 3)))))
	    (if ((null? : 1 0)
		 ((car : 1 1) ((cdr : 1 2) (x : 0 0))))
		(y : 0 1)
		(z : 0 2)))))) )

   ( (lexical-address (parse-expression ',lexp7))
     =
     (parse-lexical-addr-exp
      '(lambda (car cdr)
	 (lambda (x y z)
	   ((lambda (f)
	      (lambda (f g h y p)
		((lambda (x)
		   (if (p : 1 4)
		       ((f : 1 0) (x : 0 0) (g : 1 1))
		       ((f : 1 0) (y : 1 3) (h : 1 2))))
		 (if (g : 0 1) (h : 0 2) (y : 0 3)))))
	    (if ((null? : 2 0)
		 ((car : 1 0) ((cdr : 1 1) (x : 0 0))))
		(y : 0 1)
		(z : 0 2)))))) )

   ( (lexical-address (parse-expression ',lexp8))
     =
     (parse-lexical-addr-exp
      '(lambda (car cdr)
	 (lambda ()
	   (lambda (x y z)
	     ((lambda (f)
		(lambda (f g h y p)
		  ((lambda (x)
		     (if (p : 1 4)
			 ((f : 1 0) (x : 0 0) (g : 1 1))
			 ((f : 1 0) (y : 1 3) (h : 1 2))))
		   (if (g : 0 1) (h : 0 2) (y : 0 3)))))
	      (if ((null? : 3 0)
		   ((car : 2 0) ((cdr : 2 1) (x : 0 0))))
		  (y : 0 1)
		  (z : 0 2))))))) )

   ( (lexical-address (parse-expression ',lexp9))
     =
     (parse-lexical-addr-exp
      '(lambda (f g h y p)
	 ((lambda (x)
	    (if (p : 1 4)
		((f : 1 0) (x : 0 0) (g : 1 1))
		((f : 1 0) (y : 1 3) (h : 1 2))))
	  (if (g : 0 1) (quote h) (quote y))))) )
   )
 )

(displayln "You have to check the following outputs yourself")

(run-test-case `(lexical-address (parse-expression '(car ls))))
(run-test-case `(lexical-address (parse-expression '(if t (car ls) ls))))
(run-test-case `(lexical-address (parse-expression '(eq? cons cons))))
(run-test-case `(lexical-address (parse-expression ',lexp0)))
(run-test-case `(lexical-address (parse-expression ',lexp1)))

(displayln "Be sure to check the outputs above that have to be checked by hand")
