;; $Id: free-vars.tst,v 1.8 2006/02/14 05:50:51 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: free-vars.tst,v $ of $Date: 2006/02/14 05:50:51 $")
(newline)

(define lexp1 '(lambda (x) (f x)))
(define lexp2 `(lambda (z) (,lexp1 (g (h y)))))
(define lexp3 `(lambda (f) ,lexp2))
(define lexp4 `(,lexp3 (car (cdr (x (y (quote z)))))))
(define lexp5 `(lambda (y) ,lexp4))
(define lexp6 `(lambda (f) ,lexp4))
(define lexp7 `(,lexp5 ,lexp2))

(define run-regression-tests-set-equal?
  ;; TYPE: (-> ((3-list scheme-exp symbol datum)) void)
  (run-regression-tests-maker
   set-equal?
   pretty-print
   pretty-print))


(run-regression-tests-set-equal?
 `(
   ( (free-vars (parse-expression 'x)) = (set 'x) )
   ( (free-vars (parse-expression '(quote x))) = (set ) )
   ( (free-vars (parse-expression '(x y))) = (set 'x 'y) )
   ( (free-vars (parse-expression ',lexp1)) = (set 'f) )
   ( (free-vars (parse-expression ',lexp2))
     = (set 'f 'g 'h 'y) )
   ( (free-vars (parse-expression ',lexp3))
     = (set 'g 'h 'y) )
   ( (free-vars (parse-expression ',lexp4))
     = (set 'g 'h 'car 'cdr 'x 'y) )
   ( (free-vars (parse-expression ',lexp5))
     = (set 'g 'h 'car 'cdr 'x) )
   ( (free-vars (parse-expression ',lexp6))
     = (set 'g 'h 'car 'cdr 'x 'y) )
   ( (free-vars (parse-expression ',lexp7))
     = (set 'car 'cdr 'x 'f 'g 'h 'y) )
   ( (free-vars
      (parse-expression '((lambda (y) y) (lambda (x) (y x)))))
     = (set 'y) )
   ))


