;; $Id: free-vars-lambda-if-exp.tst,v 1.4 2006/02/14 05:50:51 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: free-vars-lambda-if-exp.tst,v $ of $Date: 2006/02/14 05:50:51 $")
(newline)

(define lexp1 '(lambda (x y) (if p (f x g) (f y h))))
(define lexp2 `(lambda (f g h y p) (,lexp1 (if g (quote h) y))))
(define lexp3 `(lambda (f) ,lexp2))
(define lexp4 `(,lexp3 (if (null? (car (cdr x))) (quote y) z)))
(define lexp5 `(lambda (x y z) ,lexp4))
(define lexp6 `(lambda (null? car cdr) ,lexp5))
(define lexp7 `(,lexp1 ,lexp4 ,lexp5))

(define run-regression-tests-set-equal?
  ;; TYPE: (-> ((3-list scheme-exp symbol datum)) void)
  (run-regression-tests-maker
   set-equal?
   pretty-print
   pretty-print))

(run-regression-tests-set-equal?
 `(
   ( (free-vars (parse-expression 'x))      = (set 'x) )
   ( (free-vars (parse-expression '(x y)))  = (set 'x 'y) )
   ( (free-vars (parse-expression '(car (x y)))) = (set 'car 'x 'y) )
   ( (free-vars (parse-expression '(if p (f x g) (f y h))))
     = (set 'x 'p 'g 'f 'y 'h) )
   ( (free-vars (parse-expression ',lexp1)) = (set 'p 'g 'f 'h) ) 
   ( (free-vars (parse-expression ',lexp2)) = (set) ) 
   ( (free-vars (parse-expression ',lexp3)) = (set) ) 
   ( (free-vars (parse-expression ',lexp4)) = (set 'null? 'car 'cdr 'x 'z) )
   ( (free-vars (parse-expression ',lexp5)) = (set 'null? 'car 'cdr) ) 
   ( (free-vars (parse-expression ',lexp6)) = (set) )
   ( (free-vars (parse-expression ',lexp7))
     = (set 'null? 'car 'cdr 'x 'z 'p 'f 'g 'h) )
   ))

