;; $Id: bound-vars.tst,v 1.8 2006/02/14 05:50:51 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: bound-vars.tst,v $ of $Date: 2006/02/14 05:50:51 $")
(newline)

(define lexp1 '(lambda (x) (f x)))
(define lexp2 `(lambda (z) (,lexp1 (g (h y)))))
(define lexp3 `(lambda (f) ,lexp2))
(define lexp4 `(,lexp3 (car (cdr (x (y (quote z)))))))
(define lexp5 `(lambda (y) ,lexp4))
(define lexp6 `(lambda (f) ,lexp4))
(define lexp7 `(,lexp5 ,lexp2))

(define run-regression-tests-set-equal?
  ;; TYPE: (-> ((3-list scheme-exp symbol datum)) void)
  (run-regression-tests-maker
   set-equal?
   pretty-print
   pretty-print))

(run-regression-tests-set-equal?
 `(
   ( (bound-vars (parse-expression 'x)) = (set) )
   ( (bound-vars (parse-expression '(quote z))) = (set) )
   ( (bound-vars (parse-expression '(x y))) = (set) )
   ( (bound-vars (parse-expression '(lambda (x) (lambda (x) y))))
     = (set) )
   ( (bound-vars (parse-expression ',lexp1)) = (set 'x) )
   ( (bound-vars (parse-expression ',lexp2)) = (set 'x) )
   ( (bound-vars (parse-expression ',lexp3)) = (set 'f 'x) )
   ( (bound-vars (parse-expression ',lexp4)) = (set 'f 'x) )
   ( (bound-vars (parse-expression ',lexp5)) = (set 'y 'f 'x) )
   ( (bound-vars (parse-expression ',lexp6)) = (set 'f 'x) )
   ( (bound-vars (parse-expression ',lexp7)) = (set 'y 'f 'x) )
   )
 )

