;; $Id: bound-vars-lambda-if-exp.tst,v 1.4 2006/02/14 05:50:51 leavens Exp leavens $

(newline)
(displayln "Test case $RCSfile: bound-vars-lambda-if-exp.tst,v $ of $Date: 2006/02/14 05:50:51 $")
(newline)

(define lexp1 '(lambda (x y) (if p (f x g) (f y h))))
(define lexp2 `(lambda (f g h y p) (,lexp1 (if g (quote h) y))))
(define lexp3 `(lambda (f) ,lexp2))
(define lexp4 `(lambda (z) (,lexp3 (if (null? (car (cdr x))) y z))))
(define lexp5 `(lambda (x y z) ,lexp4))
(define lexp6 `(lambda (null? car cdr) ,lexp5))
(define lexp7 `(,lexp1 (if g h y) ,lexp4 ,lexp5))
(define lexp8 `(lambda (car cdr) (lambda () ,lexp5)))

(define run-regression-tests-set-equal?
  ;; TYPE: (-> ((3-list scheme-exp symbol datum)) void)
  (run-regression-tests-maker
   set-equal?
   pretty-print
   pretty-print))

(run-regression-tests-set-equal?
 `(
   ( (bound-vars (parse-expression 'x)) = (set) )
   ( (bound-vars (parse-expression '(x y))) = (set) )
   ( (bound-vars (parse-expression
		     '(lambda () (lambda (x) (if p (f x) (f y)))))) 
     = (set' x) )
   ( (bound-vars (parse-expression '(if p p y)))
     = (set) )
   ( (bound-vars (parse-expression '(lambda (p) (if p y p))))
     = (set 'p) )
   ( (bound-vars (parse-expression
		     '(lambda () (lambda (x) (if p (f (quote x)) (f y)))))) 
     = (set ) )
   ( (bound-vars (parse-expression
		     '(lambda (z) (lambda (x) (if p (f x) (f y))))))
     = (set 'x) )
   ( (bound-vars (parse-expression
		     '(lambda (z) (lambda (z) (if p (f x) (f y))))))
     = (set ) )
   ( (bound-vars (parse-expression '(lambda (x y) (lambda (x z) (y z)))))
     = (set 'y 'z) )
   ( (bound-vars (parse-expression ',lexp1)) = (set 'x 'y) )
   ( (bound-vars (parse-expression ',lexp2)) = (set 'p 'f 'h 'g 'x 'y) )
   ( (bound-vars (parse-expression ',lexp3)) = (set 'p 'f 'h 'g 'x 'y) )
   ( (bound-vars (parse-expression ',lexp4)) = (set 'z 'p 'f 'h 'g 'x 'y) )
   ( (bound-vars (parse-expression ',lexp5)) = (set 'z 'p 'f 'h 'g 'x 'y) )
   ( (bound-vars (parse-expression ',lexp6))
     = (set 'null? 'car 'cdr 'z 'p 'f 'g 'h 'y 'x) )
   ( (bound-vars (parse-expression ',lexp7))
     = (set 'z 'p 'f 'h 'g 'x 'y) )
   ( (bound-vars (parse-expression ',lexp8))
     = (set 'car 'cdr 'z 'p 'f 'h 'g 'y 'x) )
   )
 )
