;;; $Id: only-selected.tst,v 1.3 2006/02/07 05:48:31 leavens Exp leavens $
;;; AUTHOR: Gary T. Leavens

(newline)
(displayln "Test case $RCSfile: only-selected.tst,v $ of $Date: 2006/02/07 05:48:31 $")
(newline)

(run-regression-tests-equal?
 `(

   ( (only-selected
      (document '() '()
                (attributed
		 'html
		 (list (name-value 'selected "true"))
		 (list ))))
     ==> (*TOP* (html)) )

   ( (only-selected
      (document
       '() '()
       (named
        'operas
	(list (child (attributed
		      'miestersinger
		      (list (name-only 'funny)
			    (name-value 'selected "true"))
		      (list (text "Fanget an! ..."))))
              (entity "decca-52" "342d-dfaa:302")
              (child-pi (PI 'your-code "deletes the following"))
              (child (attributed
		      'boheme
		      (list (name-only 'sad)
			    (name-value 'setting "paris"))
		      (list (text "Mimi coughed..."))))
	      (child-comment (comment "That's an oversimplification"))
              (child (attributed
		      'lohengrin
		      (list (name-only 'shining-armor)
			    (name-value 'selected "true"))
		      (list (text "When is the next swan? ..."))))))))
     ==> (*TOP*
	  (operas
	   (miestersinger (@ (funny)) "Fanget an! ...")
	   (*ENTITY* "decca-52" "342d-dfaa:302")
	   (*PI* your-code "deletes the following")
	   (*COMMENT* "That's an oversimplification")
	   (lohengrin (@ (shining-armor)) "When is the next swan? ..."))) )

   ( (only-selected
      '(*TOP* (*PI* x86 "run; die")
	      (*COMMENT* "those x86s...")
	      (html
	       (head (@ (selected "true") (title "Simple doc")))
	       (body (p "First paragraph.")
		     (p "Second paragraph.")))))
     ==> (*TOP* (*PI* x86 "run; die")
                (*COMMENT* "those x86s...")
                (html
                 (head (@ (title "Simple doc"))))) )

   ( (only-selected
      '(*TOP* (*PI* x86 "run; die")
	      (*COMMENT* "those x86s...")
	      (html
	       (head (@ (title "Simple doc")))
	       (body (@ (selected "true"))
		     (p "First paragraph.")
		     (p "Second paragraph.")))))
     ==> (*TOP* (*PI* x86 "run; die")	
                (*COMMENT* "those x86s...")
                (html
                 (body (p "First paragraph.")
                       (p "Second paragraph.")))) )

   ( (only-selected
      '(*TOP* (*PI* x86 "run; die")
	      (*COMMENT* "those x86s...")
	      (html
	       (head (@ (title "Simple doc")))
	       (body (p (@ (selected "true")) "First paragraph.")
		     (p (@ (selected "true")) "Second paragraph.")))))
     ==> (*TOP* (*PI* x86 "run; die")
                (*COMMENT* "those x86s...")
                (html
                 (body (p "First paragraph.")
                       (p "Second paragraph.")))) )

   ( (only-selected 
      '(*TOP*
	(WEIGHINGS
	 (WEIGHT
	  (@ (selected "true") (unit "pound"))
	  (NET (@ (certified)) "67")
	  (GROSS "95"))
	 (WEIGHT
	  (@ (unit "kgs") (selected "true"))
	  (NET (@ (certified)) "54.7")
	  (GROSS "85.2")))))
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (unit "pound"))
	    (NET (@ (certified)) "67")
	    (GROSS "95"))
	   (WEIGHT
	    (@ (unit "kgs"))
	    (NET (@ (certified)) "54.7")
	    (GROSS "85.2")))) )

   ( (only-selected 
      '(*TOP*
	(WEIGHINGS
	 (WEIGHT
	  (@ (unit "pound"))
	  (NET (@ (selected "true") (certified)) "67")
	  (GROSS "95"))
	 (WEIGHT
	  (@ (unit "kgs"))
	  (NET (@ (certified) (selected "true")) "54.7")
	  (GROSS "85.2")))) )
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (unit "pound"))
	    (NET (@ (certified)) "67"))
	   (WEIGHT
	    (@ (unit "kgs"))
	    (NET (@  (certified)) "54.7")))) )

   ( (only-selected
      '(*TOP*
	(WEIGHINGS
	 (WEIGHT
	  (@ (unit "pound"))
	  (NET (@ (certified)) "67")
	  (GROSS (@ (selected "true")) "95"))
	 (WEIGHT
	  (@ (unit "kgs"))
	  (NET (@ (certified)) "54.7")
	  (GROSS (@ (selected "true")) "85.2")))))
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (unit "pound"))
	    (GROSS "95"))
	   (WEIGHT
	    (@ (unit "kgs"))
	    (GROSS "85.2")))) )

   ( (only-selected
      '(*TOP*
	(poems
	 (poem (@ (title "The Lovesong of J. Alfred Prufrock")
		  (poet "T. S. Eliot"))
	       (stanza
		(@ (selected "true"))
		(line "Let us go then, you and I,")
		(line "When the evening is spread out against the sky")
		(line "Like a patient etherized upon a table:"))
	       (stanza 
		(line "In the room the women come and go")
		(line (@ (selected "true"))
		      "Talking of Michaelangelo.")
		(line "...")))
	 (poem (@ (title "Sonnet XLIII")
		  (from "Sonnets from the Portuguese")
		  (poet "Elizabeth Barrett Browning"))
	       (stanza
		(line "How do I love thee?  Let me count the ways.")
		(line "I love thee to the depth and breadth and height")
		(line "My soul can reach, when feeling out of sight")
		(line "For the ends of Being and ideal Grace.")
		(line "...")))
	 (poem (@ (title "To The Weavers Gin Ye Go")
		  (from "POEMS AND SONGS OF ROBERT BURNS")
		  (poet "Robert Burns"))
	       (stanza
		(line "My heart was ance as blithe and free")
		(line "As simmer days were lang;")
		(line "But a bonie, westlin weaver lad")
		(line "Has gart me change my sang."))
	       (chorus
		(line "To the weaver's gin ye go, fair maids,")
		(line "To the weaver's gin ye go;")
		(line "I rede you right, gang ne'er at night,")
		(line "To the weaver's gin ye go."))
	       (stanza
		(@ (selected "true"))
		(line "My mither sent me to the town,")
		(line "To warp a plaiden wab;")
		(line "But the weary, weary warpin o't")
		(line "Has gart me sigh and sab."))
	       (chorus
		(@ (selected "true"))
		(line "To the weaver's, &c."))))))
     ==> (*TOP*
	  (poems
	   (poem (@ (title "The Lovesong of J. Alfred Prufrock")
		    (poet "T. S. Eliot"))
		 (stanza
		  (line "Let us go then, you and I,")
		  (line "When the evening is spread out against the sky")
		  (line "Like a patient etherized upon a table:"))
		 (stanza 
		  (line	"Talking of Michaelangelo.")))
	   (poem (@ (title "To The Weavers Gin Ye Go")
		    (from "POEMS AND SONGS OF ROBERT BURNS")
		    (poet "Robert Burns"))
		 (stanza
		  (line "My mither sent me to the town,")
		  (line "To warp a plaiden wab;")
		  (line "But the weary, weary warpin o't")
		  (line "Has gart me sigh and sab."))
		 (chorus
		  (line "To the weaver's, &c."))))) )

   )
 )

(newline)
