;;; $Id: mark-selected.tst,v 1.3 2006/02/07 05:48:31 leavens Exp leavens $
;;; AUTHOR: Gary T. Leavens

(newline)
(displayln "Test case $RCSfile: mark-selected.tst,v $ of $Date: 2006/02/07 05:48:31 $")
(newline)

(define sample1
  '(*TOP*
    (WEIGHINGS
     (WEIGHT (@ (unit "pound"))
	     (NET (@ (certified)) "67")
	     (GROSS "95"))
     (WEIGHT (@ (unit "kgs"))
	     (NET (@ (certified)) "54.7")
	     (GROSS "85.2"))
    )))

(define poems
  '(*TOP*
    (poems
     (poem (@ (title "The Lovesong of J. Alfred Prufrock")
	      (poet "T. S. Eliot"))
	   (stanza
	    (line "Let us go then, you and I,")
	    (line "When the evening is spread out against the sky")
	    (line "Like a patient etherized upon a table:"))
	   (stanza
	    (line "In the room the women come and go")
	    (line "Talking of Michaelangelo.")
	    (line "...")))
    
     (poem (@ (title "Sonnet XLIII")
	      (from "Sonnets from the Portuguese")
	      (poet "Elizabeth Barrett Browning"))
	   (stanza
	    (line "How do I love thee?  Let me count the ways.")
	    (line "I love thee to the depth and breadth and height")
	    (line "My soul can reach, when feeling out of sight")
	    (line "For the ends of Being and ideal Grace.")
	    (line "...")))

     (poem (@ (title "To The Weavers Gin Ye Go")
	      (from "POEMS AND SONGS OF ROBERT BURNS")
	      (poet "Robert Burns"))
	   (stanza
	    
	    (line "My heart was ance as blithe and free")
	    (line "As simmer days were lang;")
	    (line "But a bonie, westlin weaver lad")
	    (line "Has gart me change my sang."))

	   (chorus
	    (line "To the weaver's gin ye go, fair maids,")
	    (line "To the weaver's gin ye go;")
	    (line "I rede you right, gang ne'er at night,")
	    (line "To the weaver's gin ye go."))

	   (stanza
	    (line "My mither sent me to the town,")
	    (line "To warp a plaiden wab;")
	    (line "But the weary, weary warpin o't")
	    (line "Has gart me sigh and sab."))

	   (chorus
	    (line "To the weaver's, &c.")))
     )))


(define slides
  '(*TOP*
    (html
     (head (title "Slides"))
     (body
      (p (@ (align "center"))
	 (table (@ (style "font-size: x-large"))
		(tr
		 (td (@ (align "right")) "Talks ")
		 (td (@ (align "center")) " = ")
		 (td " slides + transition"))
		(tr (td)
		    (td (@ (align "center")) " = ")
		    (td " data + control"))
		(tr (td)
		    (td (@ (align "center")) " = ")
		    (td " programs"))))
      (ul
       (li (a (@ (href "slides/slide0001.gif")) "Introduction"))
       (li (a (@ (href "slides/slide0010.gif")) "Summary")))
      ))))

(define simpledoc
  '(document
    (list (PI 'x86 "run; die"))
    (list (comment "those x86s..."))
    (named
     'html
     (list
      (child (attributed 'head
			 (list (name-value 'title "Simple doc"))
			 '()))
      (child
       (named 'body
	      (list (child (named 'p (list (text "First paragraph."))))
		    (child (named 'p (list (text "Second paragraph."))))
		    )))))))

(run-regression-tests-equal?
 `(

   ( (mark-selected
      'html
      (document '() '()
		(named
		 'html
		 (list ))))
     ==> (*TOP* (html (@ (selected "true")))) )

   ( (mark-selected 'body ,simpledoc)
     ==> (*TOP* (*PI* x86 "run; die")
		(*COMMENT* "those x86s...")
		(html
		 (head (@ (title "Simple doc")))
		 (body (@ (selected "true"))
		       (p "First paragraph.")
		       (p "Second paragraph.")))) )

   ( (mark-selected 'p ,simpledoc)
     ==> (*TOP* (*PI* x86 "run; die")
		(*COMMENT* "those x86s...")
		(html
		 (head (@ (title "Simple doc")))
		 (body (p (@ (selected "true")) "First paragraph.")
		       (p (@ (selected "true")) "Second paragraph.")))) )

   ( (mark-selected 'head ,simpledoc)
     ==> (*TOP* (*PI* x86 "run; die")
		(*COMMENT* "those x86s...")
		(html
		 (head (@ (selected "true") (title "Simple doc")))
		 (body (p "First paragraph.")
		       (p "Second paragraph.")))) )

   ( (mark-selected 'WEIGHT sample1)
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (selected "true") (unit "pound"))
	    (NET (@ (certified)) "67")
	    (GROSS "95"))
	   (WEIGHT
	    (@ (selected "true") (unit "kgs"))
	    (NET (@ (certified)) "54.7")
	    (GROSS "85.2")))) )
   ( (mark-selected 'NET sample1)
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (unit "pound"))
	    (NET (@ (selected "true") (certified)) "67")
	    (GROSS "95"))
	   (WEIGHT
	    (@ (unit "kgs"))
	    (NET (@ (selected "true") (certified)) "54.7")
	    (GROSS "85.2")))) )
   ( (mark-selected 'GROSS sample1)
     ==> (*TOP*
	  (WEIGHINGS
	   (WEIGHT
	    (@ (unit "pound"))
	    (NET (@ (certified)) "67")
	    (GROSS (@ (selected "true")) "95"))
	   (WEIGHT
	    (@ (unit "kgs"))
	    (NET (@ (certified)) "54.7")
	    (GROSS (@ (selected "true")) "85.2")))) )
   ( (mark-selected 'poem poems)
     ==> (*TOP*
	  (poems
	   (poem (@ (selected "true")
		    (title "The Lovesong of J. Alfred Prufrock")
		    (poet "T. S. Eliot"))
		 (stanza
		  (line "Let us go then, you and I,")
		  (line "When the evening is spread out against the sky")
		  (line "Like a patient etherized upon a table:"))
		 (stanza
		  (line "In the room the women come and go")
		  (line "Talking of Michaelangelo.")
		  (line "...")))
	   (poem (@ (selected "true")
		    (title "Sonnet XLIII")
		    (from "Sonnets from the Portuguese")
		    (poet "Elizabeth Barrett Browning"))
		 (stanza
		  (line "How do I love thee?  Let me count the ways.")
		  (line "I love thee to the depth and breadth and height")
		  (line "My soul can reach, when feeling out of sight")
		  (line "For the ends of Being and ideal Grace.")
		  (line "...")))
	   (poem (@ (selected "true")
		    (title "To The Weavers Gin Ye Go")
		    (from "POEMS AND SONGS OF ROBERT BURNS")
		    (poet "Robert Burns"))
		 (stanza
		  (line "My heart was ance as blithe and free")
		  (line "As simmer days were lang;")
		  (line "But a bonie, westlin weaver lad")
		  (line "Has gart me change my sang."))
		 (chorus
		  (line "To the weaver's gin ye go, fair maids,")
		  (line "To the weaver's gin ye go;")
		  (line "I rede you right, gang ne'er at night,")
		  (line "To the weaver's gin ye go."))
		 (stanza
		  (line "My mither sent me to the town,")
		  (line "To warp a plaiden wab;")
		  (line "But the weary, weary warpin o't")
		  (line "Has gart me sigh and sab."))
		 (chorus (line "To the weaver's, &c."))))) )

   ( (mark-selected 'stanza poems)
     ==> (*TOP*
	  (poems
	   (poem (@ (title "The Lovesong of J. Alfred Prufrock")
		    (poet "T. S. Eliot"))
		 (stanza
		  (@ (selected "true"))
		  (line "Let us go then, you and I,")
		  (line "When the evening is spread out against the sky")
		  (line "Like a patient etherized upon a table:"))
		 (stanza
		  (@ (selected "true"))
		  (line "In the room the women come and go")
		  (line "Talking of Michaelangelo.")
		  (line "...")))
	   (poem (@ (title "Sonnet XLIII")
		    (from "Sonnets from the Portuguese")
		    (poet "Elizabeth Barrett Browning"))
		 (stanza
		  (@ (selected "true"))
		  (line "How do I love thee?  Let me count the ways.")
		  (line "I love thee to the depth and breadth and height")
		  (line "My soul can reach, when feeling out of sight")
		  (line "For the ends of Being and ideal Grace.")
		  (line "...")))
	   (poem (@ (title "To The Weavers Gin Ye Go")
		    (from "POEMS AND SONGS OF ROBERT BURNS")
		    (poet "Robert Burns"))
		 (stanza
		  (@ (selected "true"))
		  (line "My heart was ance as blithe and free")
		  (line "As simmer days were lang;")
		  (line "But a bonie, westlin weaver lad")
		  (line "Has gart me change my sang."))
		 (chorus
		  (line "To the weaver's gin ye go, fair maids,")
		  (line "To the weaver's gin ye go;")
		  (line "I rede you right, gang ne'er at night,")
		  (line "To the weaver's gin ye go."))
		 (stanza
		  (@ (selected "true"))
		  (line "My mither sent me to the town,")
		  (line "To warp a plaiden wab;")
		  (line "But the weary, weary warpin o't")
		  (line "Has gart me sigh and sab."))
		 (chorus (line "To the weaver's, &c."))))) )
   ( (mark-selected 'line poems)
     ==> (*TOP*
	  (poems
	   (poem (@ (title "The Lovesong of J. Alfred Prufrock")
		    (poet "T. S. Eliot"))
		 (stanza
		  (line (@ (selected "true")) "Let us go then, you and I,")
		  (line (@ (selected "true"))
			"When the evening is spread out against the sky")
		  (line (@ (selected "true"))
			"Like a patient etherized upon a table:"))
		 (stanza
		  (line (@ (selected "true"))
			"In the room the women come and go")
		  (line (@ (selected "true")) "Talking of Michaelangelo.")
		  (line (@ (selected "true")) "...")))
	   (poem (@ (title "Sonnet XLIII")
		    (from "Sonnets from the Portuguese")
		    (poet "Elizabeth Barrett Browning"))
		 (stanza
		  (line (@ (selected "true"))
			"How do I love thee?  Let me count the ways.")
		  (line (@ (selected "true"))
			"I love thee to the depth and breadth and height")
		  (line (@ (selected "true"))
			"My soul can reach, when feeling out of sight")
		  (line (@ (selected "true"))
			"For the ends of Being and ideal Grace.")
		  (line (@ (selected "true")) "...")))
	   (poem (@ (title "To The Weavers Gin Ye Go")
		    (from "POEMS AND SONGS OF ROBERT BURNS")
		    (poet "Robert Burns"))
		 (stanza
		  (line (@ (selected "true"))
			"My heart was ance as blithe and free")
		  (line (@ (selected "true")) "As simmer days were lang;")
		  (line (@ (selected "true"))
			"But a bonie, westlin weaver lad")
		  (line (@ (selected "true"))
			"Has gart me change my sang."))
		 (chorus
		  (line (@ (selected "true"))
			"To the weaver's gin ye go, fair maids,")
		  (line (@ (selected "true")) "To the weaver's gin ye go;")
		  (line (@ (selected "true"))
			"I rede you right, gang ne'er at night,")
		  (line (@ (selected "true")) "To the weaver's gin ye go."))
		 (stanza
		  (line (@ (selected "true"))
			"My mither sent me to the town,")
		  (line (@ (selected "true")) "To warp a plaiden wab;")
		  (line (@ (selected "true"))
			"But the weary, weary warpin o't")
		  (line (@ (selected "true")) "Has gart me sigh and sab."))
		 (chorus
		  (line (@ (selected "true")) "To the weaver's, &c."))))) )
   ( (mark-selected 'chorus poems)
     ==> (*TOP*
	  (poems
	   (poem (@ (title "The Lovesong of J. Alfred Prufrock")
		    (poet "T. S. Eliot"))
		 (stanza
		  (line "Let us go then, you and I,")
		  (line "When the evening is spread out against the sky")
		  (line "Like a patient etherized upon a table:"))
		 (stanza
		  (line "In the room the women come and go")
		  (line "Talking of Michaelangelo.")
		  (line "...")))
	   (poem (@ (title "Sonnet XLIII")
		    (from "Sonnets from the Portuguese")
		    (poet "Elizabeth Barrett Browning"))
		 (stanza
		  (line "How do I love thee?  Let me count the ways.")
		  (line "I love thee to the depth and breadth and height")
		  (line "My soul can reach, when feeling out of sight")
		  (line "For the ends of Being and ideal Grace.")
		  (line "...")))
	   (poem (@ (title "To The Weavers Gin Ye Go")
		    (from "POEMS AND SONGS OF ROBERT BURNS")
		    (poet "Robert Burns"))
		 (stanza
		  (line "My heart was ance as blithe and free")
		  (line "As simmer days were lang;")
		  (line "But a bonie, westlin weaver lad")
		  (line "Has gart me change my sang."))
		 (chorus
		  (@ (selected "true"))
		  (line "To the weaver's gin ye go, fair maids,")
		  (line "To the weaver's gin ye go;")
		  (line "I rede you right, gang ne'er at night,")
		  (line "To the weaver's gin ye go."))
		 (stanza
		  (line "My mither sent me to the town,")
		  (line "To warp a plaiden wab;")
		  (line "But the weary, weary warpin o't")
		  (line "Has gart me sigh and sab."))
		 (chorus
		  (@ (selected "true"))
		  (line "To the weaver's, &c."))))) )

   ( (mark-selected 'td slides)
     ==> (*TOP*
	  (html (head (title "Slides"))
		(body (p (@ (align "center"))
			 (table
			  (@ (style "font-size: x-large"))
			  (tr (td (@ (selected "true") (align "right"))
				  "Talks ")
			      (td (@ (selected "true") (align "center")) " = ")
			      (td (@ (selected "true")) " slides + transition"))
			  (tr (td (@ (selected "true")))
			      (td (@ (selected "true") (align "center")) " = ")
			      (td (@ (selected "true")) " data + control"))
			  (tr (td (@ (selected "true")))
			      (td (@ (selected "true") (align "center")) " = ")
			      (td (@ (selected "true")) " programs"))))
		      (ul (li (a (@ (href "slides/slide0001.gif"))
				 "Introduction"))
			  (li (a (@ (href "slides/slide0010.gif"))
				 "Summary")))))) )
   )
 )

(newline)
