;;; $Id: set-ops.tst,v 1.3 2006/01/31 06:32:43 leavens Exp $

(newline)
(displayln "Test $RCSfile: set-ops.tst,v $ of $Date: 2006/01/31 06:32:43 $")
(newline)

(run-regression-tests-equal?
 `(
   ( (set-equal? the-empty-set (set)) ==> #t )
   ( (set-empty? the-empty-set) ==> #t )
   ( (set-empty? (set)) ==> #t )
   ( (set-empty? (set 1)) ==> #f )

   ( (set-size the-empty-set) ==> 0 )
   ( (set-size (set)) ==> 0 )
   ( (set-size (set 5 4 1)) ==> 3 )

   ( (set-equal? (set-add 1 (set)) (set)) ==> #f )
   ( (set-equal? (set-add 1 (set )) (set 1)) ==> #t )
   ( (set-equal? (set-add 1 (set 2 3)) (set 2 1 3)) ==> #t )
   ( (set-equal? (set-add 1 (set 2 3)) (set 1 2 3)) ==> #t )
   ( (set-equal? (set-add 1 (set 2 3 1)) (set 1 2 3)) ==> #t )
   ( (set-equal? (set-add 1 (set-add 2 (set)))
		 (set-add 2 (set-add 1 (set 2)))) ==> #t )

   ( (set-size (set-add 1 (set 2 3 1)) ) ==> 3 )
   ( (set-size (set-add 1 (set 2 3 1 4 8 1)) ) ==> 5 )
   ( (set-size (set-add 1 (set 2 3 1)) ) ==> 3 )
   ( (set-size (set-add 1 (set 2 3 1 4 8 1)) ) ==> 5 )

   ( (set-member? 1 (set-add 1 (set 2 3 1))) ==> #t )
   ( (set-member? 2 (set-add 1 (set 2 3 1))) ==> #t )
   ( (set-member? 3 (set-add 1 (set 2 3 1))) ==> #t )
   ( (set-member? 4 (set-add 1 (set 2 3 1))) ==> #f )

   ( (set-equal? (set-remove 1 (set 2 3 1)) (set 3 2)) ==> #t )
   ( (set-equal? (set-remove 1 (set 2 3 4 8)) (set 3 2 4 8)) ==> #t )
   ( (set-equal? (set-remove 1 (set )) the-empty-set) ==> #t )
   ( (set-equal? (set-remove 1 (set 1)) the-empty-set) ==> #t )

   ( (set-equal? (set-union (set 'a 'b) (set 'c 'd))
                 (set 'a 'b 'c 'd)) ==> #t )
   ( (set-equal? (set-union (set 'a 'b) (set 'a 'c 'd))
                 (set 'a 'b 'c 'd)) ==> #t )
   ( (set-equal? (set-union (set 'a 'b 'c) (set 'c 'd))
                 (set 'a 'b 'c 'd)) ==> #t )
   ( (set-size (set-union (set 'a 'b 'c) (set 'c 'd)) ) ==> 4 )

   ( (set-equal? (set-minus (set 'a 'b) (set 'c 'd))
                 (set 'a 'b)) ==> #t )
   ( (set-equal? (set-minus (set 'a 'b 'c) (set 'c 'a 'd))
                 (set 'b)) ==> #t )
   ( (set-equal? (set-minus (set 'a 'b 'c) (set))
                 (set 'a 'b 'c)) ==> #t )
   ( (set-equal? (set-minus (set) (set 'a 'b 'c))
                 (set)) ==> #t )

   ( (set-equal? (set-intersect (set 'a 'b) (set 'c 'd))
                 the-empty-set) ==> #t )
   ( (set-equal? (set-intersect (set 'a 'b 'c) (set 'c 'a 'd))
                 (set 'a 'c)) ==> #t )
   ( (set-equal? (set-intersect (set 1 2 5 7 13 9) (set 9 3 1 5 12 2 14))
                 (set 1 2 5 9)) ==> #t )

   ( (set-equal? (set-union-list (list (set 'a 'b) (set 'c 'd)))
               (set 'a 'b 'c 'd)) ==> #t )
   ( (set-equal? (set-union-list
                   (list (set 'a) (set 'b 'c) (set 'c 'a)))
               (set 'a 'b 'c)) ==> #t )

   ( (set-equal? (set-union* (set 'a 'b) (set 'c 'd) (set))
               (set 'a 'b 'c 'd)) ==> #t )
   ( (set-equal? (set-union* (set 'a) (set 'b 'c) (set 'c 'a))
               (set 'a 'b 'c)) ==> #t )
   ( (set-equal? (set-union* ) (set )) ==> #t )

   ))

(newline)
