;;; $Id: set-ops.scm,v 1.4 2006/02/03 13:50:58 leavens Exp leavens $
;;;
;;; Copy this file to your own directory and add your code to it as instructed
;;;---------------------------------------------------------------------

;;; Name:  <your name>

(module set-ops (lib "typedscm.ss" "typedscm")

(provide the-empty-set set-empty? set-size set set-member?
	set-one-elem set-rest set-subset? set-equal? set-add set-remove
	set-union set-minus set-intersect set-union-list set-union*)

;;;---------------------------------------------------------------------
;;; Do not change any of the following provided procedures
;;; The code you are to write follows them.
;;;---------------------------------------------------------------------

;; we are representing sets as lists (without duplicates)
(defrep (forall (T) (set-of T) (list-of T)))

(deftype the-empty-set (forall (T) (set-of T)))
(define the-empty-set '())

(deftype set-empty? (forall (T) (-> ((set-of T)) boolean)))
(define set-empty?
  (lambda (s)
    ;; ENSURES: result is true just when s is empty
    (null? s)))

(deftype set-size (forall (T) (-> ((set-of T)) number)))
(define set-size
  (lambda (s)
    ;; ENSURES: result is the number of elements in s
    (length s)))

(deftype set (forall (T) (-> (T ...) (set-of T))))
(define set
  (lambda args
    ;; ENSURES: result is a set containing just the elements in args
    (if (null? args)
        the-empty-set
        (set-add (car args) (apply set (cdr args))))))

(deftype set-member? (forall (T) (-> (T (set-of T)) boolean)))
(define set-member?
  (lambda (e S)
    ;; ENSURES: result is true just when e is equal? to some element of S
    (and (not (set-empty? S))
         (or (equal? e (car S))
             (set-member? e (cdr S))))))

(deftype set-one-elem (forall (T) (-> ((set-of T)) T)))
(define set-one-elem
  (lambda (s)
    ;; REQUIRES: s is not empty
    ;; ENSURES: result is a member of s
    (car s)))

(deftype set-rest (forall (T) (-> ((set-of T)) (set-of T))))
(define set-rest 
  (lambda (s)
    ;; REQUIRES: s is not empty
    ;; ENSURES: result is the largest subset of s that does not contain
    ;;          the element (set-one-elem s)
    (cdr s)))

(deftype set-subset? (forall (T) (-> ((set-of T) (set-of T)) boolean)))
(define set-subset?
  (lambda (S1 S2)
    ;; ENSURES: result is true just when S1 is a subset of S2,
    ;;          or equal to S2.  Membership is determined by equal?
    (or (set-empty? S1)
        (and (set-member? (set-one-elem S1) S2)
             (set-subset? (set-rest S1) S2)))))

(deftype set-equal? (forall (T) (-> ((set-of T) (set-of T)) boolean)))
(define set-equal?
  (lambda (S1 S2)
    ;; ENSURES: result is true just when S1 and S2 contain
    ;;          the same elements. Membership is determined by equal?
    (and (set-subset? S1 S2)
         (set-subset? S2 S1))))

;;;---------------------------------------------------------------------
;;; End of provided code
;;;---------------------------------------------------------------------

;;;---------------------------------------------------------------------
;;; Put your code for each procedure below the corresponding deftype:
;;;---------------------------------------------------------------------
(deftype set-add
  (forall (T) (-> (T (set-of T)) (set-of T))))


(deftype set-remove
  (forall (T) (-> (T (set-of T)) (set-of T))))


(deftype set-union
  (forall (T) (-> ((set-of T) (set-of T)) (set-of T))))


(deftype set-minus
  (forall (T) (-> ((set-of T) (set-of T)) (set-of T))))


(deftype set-intersect
  (forall (T) (-> ((set-of T) (set-of T)) (set-of T))))


(deftype set-union-list
  (forall (T) (-> ((list-of (set-of T))) (set-of T))))


(deftype set-union*
  (forall (T) (-> ((set-of T) ...) (set-of T))))


) ;; end module
